/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.BoolEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Token;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class TreeWriter {
    public static int vp8_cost_zero(int p) {
        return BoolEncoder.vp8_prob_cost[p];
    }

    public static int vp8_cost_one(int p) {
        return TreeWriter.vp8_cost_zero(TreeWriter.vp8_complement(p));
    }

    public static int vp8_cost_bit(int x, int b) {
        return TreeWriter.vp8_cost_zero(b != 0 ? TreeWriter.vp8_complement(x) : x);
    }

    public static int vp8_cost_branch(int[] ct, int p) {
        return (int)((long)ct[0] * (long)TreeWriter.vp8_cost_zero(p) + (long)ct[1] * (long)TreeWriter.vp8_cost_one(p) >> 8);
    }

    public static void vp8_write_literal(BoolEncoder bc, int data, int bits) {
        bc.vp8_encode_value(data, bits);
    }

    public static void vp8_treed_write(BoolEncoder w, ReadOnlyIntArrPointer t, ReadOnlyIntArrPointer p, int v, int n) {
        int i = 0;
        do {
            int b;
            w.vp8_encode_bool((b = v >> --n & 1) == 1, p.getRel(i >> 1));
            i = t.getRel(i + b);
        } while (n != 0);
    }

    public static void vp8_write_token(BoolEncoder w, ReadOnlyIntArrPointer t, ReadOnlyIntArrPointer p, Token x) {
        TreeWriter.vp8_treed_write(w, t, p, x.value, x.len);
    }

    public static int vp8_treed_cost(ReadOnlyIntArrPointer t, ReadOnlyIntArrPointer p, int v, int n) {
        int c = 0;
        int i = 0;
        do {
            int b = v >> --n & 1;
            c += TreeWriter.vp8_cost_bit(p.getRel(i >> 1), b);
            i = t.getRel(i + b);
        } while (n != 0);
        return c;
    }

    static int vp8_cost_token(ReadOnlyIntArrPointer t, ReadOnlyIntArrPointer p, Token x) {
        return TreeWriter.vp8_treed_cost(t, p, x.value, x.len);
    }

    static void cost(int[] C, ReadOnlyIntArrPointer T, ReadOnlyIntArrPointer P, int i, int c) {
        short p = P.getRel(i >> 1);
        do {
            short j = T.getRel(i);
            int d = c + TreeWriter.vp8_cost_bit(p, i & 1);
            if (j <= 0) {
                C[-j] = d;
                continue;
            }
            TreeWriter.cost(C, T, P, j, d);
        } while ((++i & 1) != 0);
    }

    public static void vp8_cost_tokens(int[] c, ReadOnlyIntArrPointer p, ReadOnlyIntArrPointer t) {
        TreeWriter.cost(c, t, p, 0, 0);
    }

    static void vp8_cost_tokens2(int[] c, ReadOnlyIntArrPointer p, ReadOnlyIntArrPointer t, int start) {
        TreeWriter.cost(c, t, p, start, 0);
    }

    static int vp8_complement(int p) {
        return 255 - p;
    }
}

