/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data;

import java.util.EnumMap;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.OnyxIf;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Config;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;

public class LayerContext {
    public double framerate;
    public int target_bandwidth;
    public long starting_buffer_level;
    public long optimal_buffer_level;
    public long maximum_buffer_size;
    public long starting_buffer_level_in_ms;
    public long optimal_buffer_level_in_ms;
    public long maximum_buffer_size_in_ms;
    public int avg_frame_size_for_layer;
    public long buffer_level;
    public long bits_off_target;
    public long total_actual_bits;
    public int total_target_vs_actual;
    public int worst_quality;
    public short active_worst_quality;
    public int best_quality;
    public short active_best_quality;
    public short ni_av_qi;
    public int ni_tot_qi;
    public int ni_frames;
    public short avg_frame_qindex;
    public double rate_correction_factor;
    public double key_frame_rate_correction_factor;
    public double gf_rate_correction_factor;
    public int zbin_over_quant;
    public int inter_frame_target;
    public long total_byte_count;
    public short filter_level;
    public int frames_since_last_drop_overshoot;
    public int force_maxqp;
    public int last_frame_percent_intra;
    public EnumMap<MVReferenceFrame, Integer> count_mb_ref_frame_usage = new EnumMap(MVReferenceFrame.class);
    public short[] last_q = new short[2];

    public LayerContext(Compressor cpi, Config oxcf, int layer, double prev_layer_framerate) {
        this.framerate = cpi.output_framerate / (double)cpi.oxcf.rate_decimator[layer];
        this.target_bandwidth = cpi.oxcf.target_bitrate[layer] * 1000;
        this.starting_buffer_level_in_ms = oxcf.starting_buffer_level;
        this.optimal_buffer_level_in_ms = oxcf.optimal_buffer_level;
        this.maximum_buffer_size_in_ms = oxcf.maximum_buffer_size;
        this.starting_buffer_level = OnyxIf.rescale((int)oxcf.starting_buffer_level, this.target_bandwidth, 1000);
        this.optimal_buffer_level = oxcf.optimal_buffer_level == 0L ? (long)(this.target_bandwidth / 8) : (long)OnyxIf.rescale((int)oxcf.optimal_buffer_level, this.target_bandwidth, 1000);
        this.maximum_buffer_size = oxcf.maximum_buffer_size == 0L ? (long)(this.target_bandwidth / 8) : (long)OnyxIf.rescale((int)oxcf.maximum_buffer_size, this.target_bandwidth, 1000);
        if (layer > 0) {
            this.avg_frame_size_for_layer = (int)((double)((cpi.oxcf.target_bitrate[layer] - cpi.oxcf.target_bitrate[layer - 1]) * 1000) / (this.framerate - prev_layer_framerate));
        }
        this.active_worst_quality = cpi.oxcf.worst_allowed_q;
        this.active_best_quality = cpi.oxcf.best_allowed_q;
        this.avg_frame_qindex = cpi.oxcf.worst_allowed_q;
        this.buffer_level = this.starting_buffer_level;
        this.bits_off_target = this.starting_buffer_level;
        this.total_actual_bits = 0L;
        this.ni_av_qi = 0;
        this.ni_tot_qi = 0;
        this.ni_frames = 0;
        this.rate_correction_factor = 1.0;
        this.key_frame_rate_correction_factor = 1.0;
        this.gf_rate_correction_factor = 1.0;
        this.inter_frame_target = 0;
    }
}

