/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data;

import java.util.EnumMap;
import java.util.EnumSet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.BitStream;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.CommonUtils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.DCT;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.MComp;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.OnyxIf;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.PickInter;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Quantize;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.ReconIntra;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Block;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.BlockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CommonData;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.HexSearch;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MV;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MVContext;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MacroblockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Partition_Info;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ReferenceCounts;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.SearchSite;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.YV12buffer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.BPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.SearchMethods;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.TokenAlphabet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessGenArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;

public class Macroblock {
    public static final int MAX_MODES = 20;
    public static final int MAX_ERROR_BINS = 1024;
    public FullAccessIntArrPointer src_diff = new FullAccessIntArrPointer(400);
    public FullAccessIntArrPointer coeff = new FullAccessIntArrPointer(400);
    public FullAccessIntArrPointer thismb = new FullAccessIntArrPointer(256);
    FullAccessIntArrPointer thismb_ptr;
    public FullAccessGenArrPointer<Block> block = new FullAccessGenArrPointer(25);
    public YV12buffer src;
    public MacroblockD e_mbd;
    public FullAccessGenArrPointer<Partition_Info> partition_info;
    public FullAccessGenArrPointer<Partition_Info> pi;
    public FullAccessGenArrPointer<Partition_Info> pip;
    public int[] ref_frame_cost = new int[MVReferenceFrame.count];
    public FullAccessGenArrPointer<SearchSite> ss = new FullAccessGenArrPointer(MComp.MAX_MVSEARCH_STEPS * 8 + 1);
    public int ss_count;
    public int searches_per_step;
    public int errorperbit;
    public int sadperbit16;
    public int sadperbit4;
    public int rddiv;
    public int rdmult;
    public FullAccessIntArrPointer mb_activity_ptr;
    int[] mb_norm_activity_ptr;
    public int act_zbin_adj;
    public int last_act_zbin_adj;
    public FullAccessIntArrPointer[] mvcost = new FullAccessIntArrPointer[2];
    public FullAccessIntArrPointer[] mvsadcost = new FullAccessIntArrPointer[2];
    public EnumMap<FrameType, EnumMap<MBPredictionMode, Integer>> mbmode_cost;
    public int[][] intra_uv_mode_cost = new int[MBPredictionMode.count][];
    public EnumMap<BPredictionMode, EnumMap<BPredictionMode, EnumMap<BPredictionMode, Integer>>> bmode_costs;
    public EnumMap<BPredictionMode, Integer> inter_bmode_costs;
    public int[][][][] token_costs = new int[8][3][TokenAlphabet.entropyTokenCount][];
    public short mv_col_min;
    public short mv_col_max;
    public short mv_row_min;
    public short mv_row_max;
    public boolean skip;
    public int encode_breakout;
    public FullAccessIntArrPointer gf_active_ptr;
    public FullAccessIntArrPointer active_ptr;
    MVContext[] mvc;
    public boolean optimize;
    public int q_index;
    public boolean is_skin;
    int denoise_zeromv;
    int increase_denoising;
    MBPredictionMode best_sse_inter_mode;
    MV best_sse_mv;
    MVReferenceFrame best_reference_frame;
    MVReferenceFrame best_zeromv_reference_frame;
    int need_to_clamp_best_mvs;
    public int skip_true_count;
    public int[][][][] coef_counts = new int[4][8][3][TokenAlphabet.entropyTokenCount];
    public int[][] MVcount = new int[2][2047];
    public int[] ymode_count = new int[BlockD.VP8_YMODES];
    public int[] uv_mode_count = new int[BlockD.VP8_UV_MODES];
    public long prediction_error;
    public long intra_error;
    public EnumMap<MVReferenceFrame, Integer> count_mb_ref_frame_usage = new EnumMap(MVReferenceFrame.class);
    public int[] rd_thresh_mult = new int[20];
    public int[] rd_threshes = new int[20];
    public int mbs_tested_so_far;
    public int[] mode_test_hit_counts = new int[20];
    public boolean zbin_mode_boost_enabled;
    public int zbin_mode_boost;
    public int last_zbin_mode_boost;
    public int last_zbin_over_quant;
    public int zbin_over_quant;
    public int[] error_bins = new int[1024];
    public DCT.TRANSFORM short_fdct4x4;
    public DCT.TRANSFORM short_fdct8x4;
    public DCT.TRANSFORM short_walsh4x4;
    public Quantize.Quant quantize_b;
    public int mbs_zero_last_dot_suppress;
    public boolean zero_last_dot_suppress;
    public final ReconIntra recon = new ReconIntra();
    public final PickInter interPicker = new PickInter();
    public final HexSearch hex = new HexSearch();
    static final int[] sad_per_bit16lut = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14};
    static final int[] sad_per_bit4lut = new int[]{2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 20};

    public Macroblock(Compressor cpi) {
        this.mvcost[0] = cpi.rd_costs.mvcosts[0].shallowCopyWithPosInc(1024);
        this.mvcost[1] = cpi.rd_costs.mvcosts[1].shallowCopyWithPosInc(1024);
        this.mvsadcost[0] = cpi.rd_costs.mvsadcosts[0].shallowCopyWithPosInc(256);
        this.mvsadcost[1] = cpi.rd_costs.mvsadcosts[1].shallowCopyWithPosInc(256);
        Macroblock.cal_mvsadcosts(this.mvsadcost);
        this.mbmode_cost = cpi.rd_costs.mbmode_cost;
        this.intra_uv_mode_cost = cpi.rd_costs.intra_uv_mode_cost;
        this.bmode_costs = cpi.rd_costs.bmode_costs;
        this.inter_bmode_costs = cpi.rd_costs.inter_bmode_costs;
        this.token_costs = cpi.rd_costs.token_costs;
        this.error_bins[0] = cpi.common.MBs;
        this.vp8_setup_block_ptrs();
        this.vp8_alloc_partition_data(cpi);
        this.e_mbd = new MacroblockD(cpi);
        this.resetSpeedFeatures();
        this.changeFNs(cpi);
        for (int i = 0; i < this.rd_thresh_mult.length; ++i) {
            this.rd_thresh_mult[i] = 128;
        }
        this.initRefFrameCounts();
    }

    static void cal_mvsadcosts(FullAccessIntArrPointer[] mvsadcost) {
        int i = 1;
        mvsadcost[0].set((short)300);
        mvsadcost[1].set((short)300);
        do {
            double z = 256.0 * (2.0 * (OnyxIf.log2f(8 * i) + 0.6));
            mvsadcost[0].setRel(i, (short)z);
            mvsadcost[1].setRel(i, (short)z);
            mvsadcost[0].setRel(-i, (short)z);
            mvsadcost[1].setRel(-i, (short)z);
        } while (++i <= 255);
    }

    private void initRefFrameCounts() {
        for (MVReferenceFrame rf : MVReferenceFrame.validFrames) {
            this.count_mb_ref_frame_usage.put(rf, 0);
        }
    }

    private void vp8_setup_block_ptrs() {
        int c;
        int r;
        for (r = 0; r < 4; ++r) {
            for (c = 0; c < 4; ++c) {
                this.block.setRel(r * 4 + c, new Block(this.src_diff.shallowCopyWithPosInc(r * 4 * 16 + c * 4)));
            }
        }
        for (r = 0; r < 2; ++r) {
            for (c = 0; c < 2; ++c) {
                this.block.setRel(16 + r * 2 + c, new Block(this.src_diff.shallowCopyWithPosInc(256 + r * 4 * 8 + c * 4)));
            }
        }
        for (r = 0; r < 2; ++r) {
            for (c = 0; c < 2; ++c) {
                this.block.setRel(20 + r * 2 + c, new Block(this.src_diff.shallowCopyWithPosInc(320 + r * 4 * 8 + c * 4)));
            }
        }
        this.block.setRel(24, new Block(this.src_diff.shallowCopyWithPosInc(384)));
        for (int i = 0; i < 25; ++i) {
            this.block.getRel((int)i).coeff = this.coeff.shallowCopyWithPosInc(i * 16);
        }
    }

    private void vp8_alloc_partition_data(Compressor cpi) {
        this.pip = new FullAccessGenArrPointer((cpi.common.mb_cols + 1) * (cpi.common.mb_rows + 1));
        for (int i = 0; i < this.pip.size(); ++i) {
            this.pip.setRel(i, new Partition_Info());
        }
        this.pi = this.pip.shallowCopyWithPosInc(cpi.common.mode_info_stride + 1);
    }

    public void resetSpeedFeatures() {
        this.mbs_tested_so_far = 0;
        this.mbs_zero_last_dot_suppress = 0;
    }

    private void prepInitMotionComp() {
        this.ss_count = 1;
        this.ss.set(new SearchSite(0, 0, 0));
    }

    private void init_addBasicSearchSites(int stride, int Len) {
        this.ss.incBy(this.ss_count);
        this.ss.setAndInc(new SearchSite(-Len, 0, -Len * stride));
        this.ss.setAndInc(new SearchSite(Len, 0, Len * stride));
        this.ss.setAndInc(new SearchSite(0, -Len, -Len));
        this.ss.setAndInc(new SearchSite(0, Len, Len));
        this.ss_count += 4;
        this.ss.rewind();
    }

    private void vp8_init3smotion_compensation(int stride) {
        this.prepInitMotionComp();
        for (int Len = MComp.MAX_FIRST_STEP; Len > 0; Len >>= 1) {
            this.init_addBasicSearchSites(stride, Len);
            this.ss.incBy(this.ss_count);
            this.ss.setAndInc(new SearchSite(-Len, -Len, -Len * stride - Len));
            this.ss.setAndInc(new SearchSite(-Len, Len, -Len * stride + Len));
            this.ss.setAndInc(new SearchSite(Len, -Len, Len * stride - Len));
            this.ss.setAndInc(new SearchSite(Len, Len, Len * stride + Len));
            this.ss.rewind();
            this.ss_count += 4;
        }
        this.searches_per_step = 8;
    }

    private void vp8_init_dsmotion_compensation(int stride) {
        this.prepInitMotionComp();
        for (int Len = MComp.MAX_FIRST_STEP; Len > 0; Len >>= 1) {
            this.init_addBasicSearchSites(stride, Len);
        }
        this.searches_per_step = 4;
    }

    public void changeFNs(Compressor cpi) {
        CommonData cm = cpi.common;
        if (cpi.sf.search_method == SearchMethods.NSTEP) {
            this.vp8_init3smotion_compensation(cm.yv12_fb[cm.frameIdxs.get((Object)((Object)MVReferenceFrame.LAST_FRAME)).intValue()].y_stride);
        } else if (cpi.sf.search_method == SearchMethods.DIAMOND) {
            this.vp8_init_dsmotion_compensation(cm.yv12_fb[cm.frameIdxs.get((Object)((Object)MVReferenceFrame.LAST_FRAME)).intValue()].y_stride);
        }
        if (cpi.sf.improved_dct) {
            this.short_fdct8x4 = DCT.vp8_short_fdct8x4;
            this.short_fdct4x4 = DCT.vp8_short_fdct4x4;
        } else {
            this.short_fdct8x4 = DCT.vp8_short_fdct8x4;
            this.short_fdct4x4 = DCT.vp8_short_fdct4x4;
        }
        this.short_walsh4x4 = DCT.vp8_short_walsh4x4;
        this.quantize_b = cpi.sf.improved_quant ? Quantize.regularQuant : Quantize.fastQuant;
        this.optimize = cpi.sf.optimize_coefficients;
    }

    public void vp8cx_initialize_me_consts(int QIndex) {
        this.sadperbit16 = sad_per_bit16lut[QIndex];
        this.sadperbit4 = sad_per_bit4lut[QIndex];
    }

    public ReferenceCounts sumReferenceCounts() {
        int inter = 0;
        for (MVReferenceFrame rf : EnumSet.range(MVReferenceFrame.LAST_FRAME, MVReferenceFrame.ALTREF_FRAME)) {
            inter += this.count_mb_ref_frame_usage.get((Object)rf).intValue();
        }
        return new ReferenceCounts(this.count_mb_ref_frame_usage.get((Object)MVReferenceFrame.INTRA_FRAME), inter);
    }

    public void init_encode_frame_mb_context(Compressor cpi) {
        this.gf_active_ptr = cpi.gf_active_flags.shallowCopy();
        this.mb_activity_ptr = cpi.mb_activity_map.shallowCopy();
        this.act_zbin_adj = 0;
        this.partition_info = this.pi.shallowCopy();
        this.src = cpi.sourceYV12.shallowCopy();
        this.vp8_build_block_offsets();
        this.mvc = cpi.common.fc.mvc;
        if (cpi.ref_frame_flags.contains((Object)MVReferenceFrame.LAST_FRAME) && cpi.ref_frame_flags.size() == 1) {
            BitStream.vp8_calc_ref_frame_costs(this.ref_frame_cost, cpi.prob_intra_coded, 255, 128);
        } else if (cpi.oxcf.number_of_layers > 1 && cpi.ref_frame_flags.contains((Object)MVReferenceFrame.GOLDEN_FRAME) && cpi.ref_frame_flags.size() == 1) {
            BitStream.vp8_calc_ref_frame_costs(this.ref_frame_cost, cpi.prob_intra_coded, 1, 255);
        } else if (cpi.oxcf.number_of_layers > 1 && cpi.ref_frame_flags.contains((Object)MVReferenceFrame.ALTREF_FRAME) && cpi.ref_frame_flags.size() == 1) {
            BitStream.vp8_calc_ref_frame_costs(this.ref_frame_cost, cpi.prob_intra_coded, 1, 1);
        } else {
            BitStream.vp8_calc_ref_frame_costs(this.ref_frame_cost, cpi.prob_intra_coded, cpi.prob_last_coded, cpi.prob_gf_coded);
        }
        CommonUtils.vp8_zero(this.coef_counts);
        CommonUtils.vp8_zero(this.ymode_count);
        CommonUtils.vp8_zero(this.uv_mode_count);
        this.prediction_error = 0L;
        this.intra_error = 0L;
        this.initRefFrameCounts();
    }

    void vp8_build_block_offsets() {
        Block this_block;
        int bc;
        int br;
        this.e_mbd.vp8_build_block_doffsets();
        this.thismb_ptr = this.thismb.shallowCopy();
        for (br = 0; br < 4; ++br) {
            for (bc = 0; bc < 4; ++bc) {
                this_block = this.block.getAndInc();
                this_block.base_src = this.thismb_ptr;
                this_block.src_stride = 16;
                this_block.src = 4 * br * 16 + 4 * bc;
            }
        }
        for (br = 0; br < 2; ++br) {
            for (bc = 0; bc < 2; ++bc) {
                this_block = this.block.getAndInc();
                this_block.base_src = this.src.u_buffer;
                this_block.src_stride = this.src.uv_stride;
                this_block.src = 4 * br * this_block.src_stride + 4 * bc;
            }
        }
        for (br = 0; br < 2; ++br) {
            for (bc = 0; bc < 2; ++bc) {
                this_block = this.block.getAndInc();
                this_block.base_src = this.src.v_buffer;
                this_block.src_stride = this.src.uv_stride;
                this_block.src = 4 * br * this_block.src_stride + 4 * bc;
            }
        }
        this.block.rewind();
    }
}

