/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data;

import java.util.EnumMap;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.VP8Util;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.TreeWriter;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.EntropyMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.BPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.TokenAlphabet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.PositionableIntArrPointer;

public class RDCosts {
    FullAccessIntArrPointer[] mvcosts = new FullAccessIntArrPointer[2];
    FullAccessIntArrPointer[] mvsadcosts = new FullAccessIntArrPointer[2];
    EnumMap<FrameType, EnumMap<MBPredictionMode, Integer>> mbmode_cost = new EnumMap(FrameType.class);
    int[][] intra_uv_mode_cost = new int[2][MBPredictionMode.count];
    EnumMap<BPredictionMode, EnumMap<BPredictionMode, EnumMap<BPredictionMode, Integer>>> bmode_costs = new EnumMap(BPredictionMode.class);
    EnumMap<BPredictionMode, Integer> inter_bmode_costs = new EnumMap(BPredictionMode.class);
    int[][][][] token_costs = new int[4][8][3][TokenAlphabet.entropyTokenCount];
    private EnumMap<FrameType, int[]> costArrayCache = new EnumMap(FrameType.class);
    private int[] bpmHelper = new int[BPredictionMode.bpredModecount];

    public RDCosts() {
        RDCosts.initcostarr(this.mvcosts, 2048);
        RDCosts.initcostarr(this.mvsadcosts, 512);
        for (FrameType frameType : FrameType.values()) {
            this.mbmode_cost.put(frameType, new EnumMap(MBPredictionMode.class));
        }
        for (Enum enum_ : BPredictionMode.values()) {
            EnumMap submap = new EnumMap(BPredictionMode.class);
            for (BPredictionMode b2pm : BPredictionMode.values()) {
                submap.put(b2pm, new EnumMap(BPredictionMode.class));
            }
            this.bmode_costs.put((BPredictionMode)enum_, submap);
        }
    }

    private static void initcostarr(FullAccessIntArrPointer[] carr, int size) {
        carr[0] = new FullAccessIntArrPointer(size);
        carr[1] = new FullAccessIntArrPointer(size);
    }

    public int[] getMBmodeCostAsArray(FrameType t) {
        int[] ret = this.costArrayCache.get((Object)t);
        if (ret == null) {
            ret = new int[MBPredictionMode.count];
            this.costArrayCache.put(t, ret);
        }
        EnumMap<MBPredictionMode, Integer> data = this.mbmode_cost.get((Object)t);
        for (MBPredictionMode mode : MBPredictionMode.validModes) {
            Integer v = data.get((Object)mode);
            ret[mode.ordinal()] = v == null ? 0 : v;
        }
        return ret;
    }

    public void setMBmodeCostAsArray(FrameType t) {
        EnumMap<MBPredictionMode, Integer> data = this.mbmode_cost.get((Object)t);
        int i = 0;
        int[] arr = this.costArrayCache.get((Object)t);
        for (MBPredictionMode mode : MBPredictionMode.validModes) {
            data.put(mode, arr[i++]);
        }
    }

    private void bpmMaptoArray(EnumMap<BPredictionMode, Integer> data) {
        for (BPredictionMode mode : BPredictionMode.validmodes) {
            Integer v = data.get((Object)mode);
            this.bpmHelper[mode.ordinal()] = v == null ? 0 : v;
        }
    }

    private void arraytoBpmMap(EnumMap<BPredictionMode, Integer> data) {
        int i = 0;
        for (BPredictionMode mode : BPredictionMode.validmodes) {
            data.put(mode, this.bpmHelper[i++]);
        }
    }

    public void vp8_init_mode_costs(Compressor c) {
        PositionableIntArrPointer T = EntropyMode.vp8_bmode_tree;
        for (BPredictionMode bpO : BPredictionMode.bintramodes) {
            for (BPredictionMode bpI : BPredictionMode.bintramodes) {
                this.bpmMaptoArray(this.bmode_costs.get((Object)bpO).get((Object)bpI));
                TreeWriter.vp8_cost_tokens(this.bpmHelper, FullAccessIntArrPointer.toPointer(VP8Util.SubblockConstants.keyFrameSubblockModeProb[bpO.ordinal()][bpI.ordinal()]), T);
                this.arraytoBpmMap(this.bmode_costs.get((Object)bpO).get((Object)bpI));
            }
        }
        this.bpmMaptoArray(this.inter_bmode_costs);
        TreeWriter.vp8_cost_tokens(this.bpmHelper, c.common.fc.bmode_prob, T);
        TreeWriter.vp8_cost_tokens(this.bpmHelper, c.common.fc.sub_mv_ref_prob, EntropyMode.vp8_sub_mv_ref_tree);
        this.arraytoBpmMap(this.inter_bmode_costs);
        int[] temp = this.getMBmodeCostAsArray(FrameType.INTER_FRAME);
        TreeWriter.vp8_cost_tokens(temp, c.common.fc.ymode_prob, EntropyMode.vp8_ymode_tree);
        this.setMBmodeCostAsArray(FrameType.INTER_FRAME);
        temp = this.getMBmodeCostAsArray(FrameType.KEY_FRAME);
        TreeWriter.vp8_cost_tokens(temp, EntropyMode.vp8_kf_ymode_prob, EntropyMode.vp8_kf_ymode_tree);
        this.setMBmodeCostAsArray(FrameType.KEY_FRAME);
        TreeWriter.vp8_cost_tokens(this.intra_uv_mode_cost[1], c.common.fc.uv_mode_prob, EntropyMode.vp8_uv_mode_tree);
        TreeWriter.vp8_cost_tokens(this.intra_uv_mode_cost[0], EntropyMode.vp8_kf_uv_mode_prob, EntropyMode.vp8_uv_mode_tree);
    }
}

