/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.intrapred;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.VP8Util;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.intrapred.BlockSizeSpecificPredictor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.PositionableIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class D135Predictor
extends BlockSizeSpecificPredictor {
    public D135Predictor(int bs) {
        super(bs);
    }

    @Override
    public void call(FullAccessIntArrPointer dst, int stride, ReadOnlyIntArrPointer above, ReadOnlyIntArrPointer left) {
        int i;
        FullAccessIntArrPointer border = new FullAccessIntArrPointer(63);
        PositionableIntArrPointer pLeft = PositionableIntArrPointer.makePositionable(left);
        pLeft.incBy(this.bs);
        for (i = 0; i < this.bs - 2; ++i) {
            border.setAndInc(VP8Util.avg3(pLeft.getRel(3 - i), pLeft.getRel(2 - i), pLeft.getRel(1 - i)));
        }
        border.setAndInc(VP8Util.avg3(above.getRel(-1), left.get(), left.getRel(1)));
        border.setAndInc(VP8Util.avg3(left.get(), above.getRel(-1), above.get()));
        border.setAndInc(VP8Util.avg3(above.getRel(-1), above.get(), above.getRel(1)));
        for (i = 0; i < this.bs - 2; ++i) {
            border.setAndInc(VP8Util.avg3(above.getRel(i), above.getRel(i + 1), above.getRel(i + 2)));
        }
        border.rewind();
        for (i = 0; i < this.bs; ++i) {
            dst.memcopyin(i * stride, border, this.bs - 1 - i, this.bs);
        }
    }
}

