/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper;

import java.util.ArrayList;
import java.util.Arrays;

public class FullAccessGenArrPointer<T> {
    ArrayList<T> arr;
    int pos;
    private int savedPos;

    public FullAccessGenArrPointer(int size) {
        this.arr = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.arr.add(null);
        }
    }

    public FullAccessGenArrPointer(T[] data, int pos) {
        this.arr = new ArrayList();
        this.arr.addAll(Arrays.asList(data));
        this.pos = pos;
        this.savedPos = pos;
    }

    public FullAccessGenArrPointer(FullAccessGenArrPointer<T> other) {
        this.arr = other.arr;
        this.pos = other.pos;
        this.savedPos = other.savedPos;
    }

    public T get() {
        return this.arr.get(this.pos);
    }

    public T getRel(int r) {
        return this.arr.get(this.pos + r);
    }

    public int size() {
        return this.arr.size();
    }

    public void dec() {
        --this.pos;
    }

    public T getAndInc() {
        return this.arr.get(this.pos++);
    }

    public void inc() {
        ++this.pos;
    }

    public void incBy(int r) {
        this.pos += r;
    }

    public void rewind() {
        this.pos = 0;
    }

    public void rewindToSaved() {
        this.pos = this.savedPos;
    }

    public void savePos() {
        this.savedPos = this.pos;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int p) {
        this.pos = p;
    }

    public T set(T v) {
        this.arr.set(this.pos, v);
        return v;
    }

    public T setAndInc(T v) {
        this.arr.set(this.pos++, v);
        return v;
    }

    public T setRel(int r, T v) {
        this.arr.set(this.pos + r, v);
        return v;
    }

    public void memset(int rel, T v, int len) {
        int start = this.pos + rel;
        int stop = start + len;
        for (int i = start; i < stop; ++i) {
            this.arr.set(i, v);
        }
    }

    public FullAccessGenArrPointer<T> shallowCopy() {
        return new FullAccessGenArrPointer<T>(this);
    }

    public FullAccessGenArrPointer<T> shallowCopyWithPosInc(int by) {
        FullAccessGenArrPointer<T> ret = this.shallowCopy();
        ret.incBy(by);
        return ret;
    }

    public int pointerDiff(FullAccessGenArrPointer<T> other) {
        return other.pos - this.pos;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FullAccessGenArrPointer) {
            FullAccessGenArrPointer other = (FullAccessGenArrPointer)obj;
            return other.arr == this.arr && other.pos == this.pos;
        }
        return false;
    }
}

