/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper;

public class ReadOnlyIntArrPointer
implements Comparable<ReadOnlyIntArrPointer> {
    protected final short[] arr;
    protected int pos;

    public ReadOnlyIntArrPointer(short[] data, int pos) {
        if (pos >= data.length || pos < 0) {
            throw new ExceptionInInitializerError("Tried to initialise a pointer with position outside the backing array");
        }
        this.arr = data;
        this.pos = pos;
    }

    public ReadOnlyIntArrPointer(ReadOnlyIntArrPointer other) {
        this.arr = other.arr;
        this.pos = other.pos;
    }

    public short get() {
        return this.arr[this.pos];
    }

    public short getRel(int r) {
        return this.arr[this.pos + r];
    }

    public short getAbs(int p) {
        return this.arr[p];
    }

    public short getAbs(Enum<?> e) {
        return this.arr[e.ordinal()];
    }

    public int size() {
        return this.arr.length;
    }

    public int getRemaining() {
        return this.arr.length - this.pos;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReadOnlyIntArrPointer) {
            ReadOnlyIntArrPointer other = (ReadOnlyIntArrPointer)obj;
            return other.arr == this.arr && other.pos == this.pos;
        }
        return false;
    }

    public int pointerDiff(ReadOnlyIntArrPointer other) {
        if (other.arr != this.arr) {
            throw new RuntimeException("Tried to calculate a pointer difference on data not backed by the same array");
        }
        return other.pos - this.pos;
    }

    public void memcopyout(int rel, short[] target, int trel, int amount) {
        System.arraycopy(this.arr, this.pos + rel, target, trel, amount);
    }

    @Override
    public int compareTo(ReadOnlyIntArrPointer arg0) {
        int compResult;
        boolean sameArray = arg0.arr == this.arr;
        int n = compResult = sameArray ? 0 : Integer.compare(arg0.arr.length, this.arr.length);
        if (compResult == 0 && !sameArray) {
            for (int i = 0; i < this.arr.length && compResult == 0; ++i) {
                compResult = Short.compare(this.arr[i], arg0.arr[i]);
            }
        }
        return compResult;
    }
}

