/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.common;

import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Rational;

public class XMLMapper {
    public static <T> T map(InputStream is, Class<T> clz, TypeHandler th) throws ReflectiveOperationException, XMLStreamException {
        XMLInputFactory xmlInFact = XMLInputFactory.newInstance();
        XMLStreamReader reader = xmlInFact.createXMLStreamReader(is);
        while (!reader.isStartElement()) {
            reader.next();
        }
        return XMLMapper.parseInternal(reader, clz, th);
    }

    public static <T> T parseInternal(XMLStreamReader reader, Class<T> clz, TypeHandler th) throws ReflectiveOperationException, XMLStreamException {
        Constructor<?> constructor = clz.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Object instance = constructor.newInstance(new Object[0]);
        Field[] fields = clz.getDeclaredFields();
        Method[] methods = clz.getDeclaredMethods();
        int level = 0;
        int suspend = 0;
        while (reader.hasNext()) {
            if (level != 0) {
                reader.next();
            }
            if (reader.isStartElement()) {
                AccessibleObject found;
                System.out.println("<" + reader.getLocalName() + ">");
                if (level == 0) {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        found = XMLMapper.findSettableField(reader.getAttributeLocalName(i), fields, th);
                        if (found == null) continue;
                        ((Field)found).setAccessible(true);
                        ((Field)found).set(instance, XMLMapper.toType(reader.getAttributeValue(i), ((Field)found).getType(), th));
                    }
                } else if (suspend == 0 || level <= suspend) {
                    Object parsed;
                    Field field = XMLMapper.findField(reader.getLocalName(), fields);
                    if (field != null) {
                        field.setAccessible(true);
                        Class<?> type = field.getType();
                        if (XMLMapper.isParsableType(th, field)) {
                            String str = XMLMapper.getStringContent(reader);
                            parsed = XMLMapper.toType(str, type, th);
                        } else {
                            parsed = XMLMapper.parseInternal(reader, type, th);
                        }
                        field.set(instance, parsed);
                    }
                    if ((found = XMLMapper.findMethod(reader.getLocalName(), methods)) != null) {
                        ((Method)found).setAccessible(true);
                        parsed = XMLMapper.parseInternal(reader, ((Method)found).getParameterTypes()[0], th);
                        ((Method)found).invoke(instance, parsed);
                    } else {
                        suspend = level;
                    }
                }
                ++level;
            }
            if (!reader.isEndElement()) continue;
            System.out.println("</" + reader.getLocalName() + ">");
            if (--level == 0) break;
            if (level != suspend) continue;
            suspend = 0;
        }
        return (T)instance;
    }

    private static String getStringContent(XMLStreamReader reader) throws XMLStreamException {
        int level = 0;
        StringBuilder charContent = new StringBuilder();
        while (reader.hasNext()) {
            if (level != 0) {
                reader.next();
            }
            if (reader.isCharacters()) {
                charContent.append(reader.getText());
            }
            if (reader.isStartElement()) {
                ++level;
            }
            if (!reader.isEndElement() || --level != 0) continue;
            break;
        }
        return charContent.toString();
    }

    private static Object toType(String attributeValue, Class<?> type, TypeHandler th) {
        if (type == String.class) {
            return attributeValue;
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(attributeValue);
        }
        if (type == Long.TYPE) {
            return Long.parseLong(attributeValue);
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(attributeValue);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(attributeValue));
        }
        if (type == Short.TYPE) {
            return Short.parseShort(attributeValue);
        }
        if (type == Boolean.TYPE) {
            return Boolean.parseBoolean(attributeValue);
        }
        if (type == Rational.class) {
            return Rational.parseRational(attributeValue);
        }
        return th == null ? null : th.parse(attributeValue, type);
    }

    private static Method findMethod(String localName, Method[] methods) {
        for (Method method : methods) {
            if (!method.getName().equals("add" + localName)) continue;
            return method;
        }
        return null;
    }

    private static Field findField(String localName, Field[] fields) {
        for (Field field : fields) {
            if (!XMLMapper.xml(field.getName()).equals(localName)) continue;
            return field;
        }
        return null;
    }

    private static String xml(String arg) {
        char[] charArray = arg.toCharArray();
        if (charArray.length > 0) {
            charArray[0] = Character.toUpperCase(charArray[0]);
        }
        return new String(charArray);
    }

    private static Field findSettableField(String localName, Field[] fields, TypeHandler th) {
        for (Field field : fields) {
            if (!XMLMapper.isParsableType(th, field) || !field.getName().equals(localName)) continue;
            return field;
        }
        return null;
    }

    private static boolean isParsableType(TypeHandler th, Field field) {
        return field.getType() == String.class || field.getType().isPrimitive() || field.getType() == Rational.class || th != null && th.supports(field.getType());
    }

    public static interface TypeHandler {
        public Object parse(String var1, Class<?> var2);

        public boolean supports(Class<?> var1);
    }
}

