/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.common.UsedViaReflection;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.MKVType;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlMaster;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.util.EbmlUtil;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public abstract class EbmlBase {
    protected EbmlMaster parent;
    public MKVType type;
    public byte[] id;
    public int dataLen = 0;
    public long offset;
    public long dataOffset;
    public int typeSizeLength;

    @UsedViaReflection
    public EbmlBase(byte[] id) {
        this.id = id;
    }

    public boolean equalId(byte[] typeId) {
        return Platform.arrayEqualsByte(this.id, typeId);
    }

    public abstract ByteBuffer getData();

    public long size() {
        return this.dataLen + EbmlUtil.ebmlLength(this.dataLen) + this.id.length;
    }

    public long mux(SeekableByteChannel os) throws IOException {
        ByteBuffer bb = this.getData();
        return os.write(bb);
    }
}

