/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.H264Utils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.mp4.AvcCBox;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.Codec;
import net.creeperhost.blockshot.repack.org.jcodec.common.Demuxer;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrackMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.SeekableDemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.TrackType;
import net.creeperhost.blockshot.repack.org.jcodec.common.UsedViaReflection;
import net.creeperhost.blockshot.repack.org.jcodec.common.VideoCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.ColorSpace;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Size;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.TapeTimecode;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.MKVParser;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.MKVType;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlBase;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlBin;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlFloat;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlMaster;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlString;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlUint;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.MkvBlock;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.util.EbmlUtil;

public final class MKVDemuxer
implements Demuxer {
    private VideoTrack vTrack = null;
    private List<AudioTrack> aTracks;
    private List<SubtitlesTrack> subsTracks;
    private List<EbmlMaster> t;
    private SeekableByteChannel channel;
    int timescale = 1;
    int pictureWidth;
    int pictureHeight;
    private static Map<String, Codec> codecVideoMapping = new HashMap<String, Codec>();
    private static Map<String, Codec> codecAudioMapping;
    private static Map<String, Codec> codecSubtitleMapping;

    public MKVDemuxer(SeekableByteChannel fileChannelWrapper) throws IOException {
        this.channel = fileChannelWrapper;
        this.aTracks = new ArrayList<AudioTrack>();
        this.subsTracks = new ArrayList<SubtitlesTrack>();
        MKVParser parser = new MKVParser(this.channel);
        this.t = parser.parse();
        this.demux();
    }

    private void demux() {
        MKVType[] path = new MKVType[]{MKVType.Segment, MKVType.Info, MKVType.TimecodeScale};
        EbmlUint ts = (EbmlUint)MKVType.findFirstTree(this.t, path);
        if (ts != null) {
            this.timescale = (int)ts.getUint();
        }
        MKVType[] path9 = new MKVType[]{MKVType.Segment, MKVType.Tracks, MKVType.TrackEntry};
        for (EbmlMaster elemTrack : MKVType.findList(this.t, EbmlMaster.class, path9)) {
            Codec codec;
            EbmlString codecId;
            MKVType[] path10;
            MKVType[] path1 = new MKVType[]{MKVType.TrackEntry, MKVType.TrackType};
            long type = ((EbmlUint)MKVType.findFirst(elemTrack, path1)).getUint();
            MKVType[] path2 = new MKVType[]{MKVType.TrackEntry, MKVType.TrackNumber};
            long id = ((EbmlUint)MKVType.findFirst(elemTrack, path2)).getUint();
            if (type == 1L) {
                if (this.vTrack != null) {
                    throw new RuntimeException("More then 1 video track, can not compute...");
                }
                MKVType[] path3 = new MKVType[]{MKVType.TrackEntry, MKVType.CodecPrivate};
                path10 = new MKVType[]{MKVType.TrackEntry, MKVType.CodecID};
                codecId = (EbmlString)MKVType.findFirst(elemTrack, path10);
                codec = codecVideoMapping.get(codecId.getString());
                if (codec == null) {
                    System.out.println("Unknown video codec: '" + codecId.getString() + "'");
                }
                EbmlBin videoCodecState = (EbmlBin)MKVType.findFirst(elemTrack, path3);
                ByteBuffer state = null;
                if (videoCodecState != null) {
                    state = videoCodecState.data;
                }
                MKVType[] path4 = new MKVType[]{MKVType.TrackEntry, MKVType.Video, MKVType.PixelWidth};
                EbmlUint width = (EbmlUint)MKVType.findFirst(elemTrack, path4);
                MKVType[] path5 = new MKVType[]{MKVType.TrackEntry, MKVType.Video, MKVType.PixelHeight};
                EbmlUint height = (EbmlUint)MKVType.findFirst(elemTrack, path5);
                MKVType[] path6 = new MKVType[]{MKVType.TrackEntry, MKVType.Video, MKVType.DisplayWidth};
                EbmlUint dwidth = (EbmlUint)MKVType.findFirst(elemTrack, path6);
                MKVType[] path7 = new MKVType[]{MKVType.TrackEntry, MKVType.Video, MKVType.DisplayHeight};
                EbmlUint dheight = (EbmlUint)MKVType.findFirst(elemTrack, path7);
                MKVType[] path8 = new MKVType[]{MKVType.TrackEntry, MKVType.Video, MKVType.DisplayUnit};
                EbmlUint unit = (EbmlUint)MKVType.findFirst(elemTrack, path8);
                if (width != null && height != null) {
                    this.pictureWidth = (int)width.getUint();
                    this.pictureHeight = (int)height.getUint();
                } else if (dwidth != null && dheight != null) {
                    if (unit == null || unit.getUint() == 0L) {
                        this.pictureHeight = (int)dheight.getUint();
                        this.pictureWidth = (int)dwidth.getUint();
                    } else {
                        throw new RuntimeException("DisplayUnits other then 0 are not implemented yet");
                    }
                }
                this.vTrack = new VideoTrack(this, (int)id, state, codec);
                continue;
            }
            if (type == 2L) {
                MKVType[] path5;
                EbmlString tagLanguage;
                MKVType[] path4;
                EbmlUint channels;
                MKVType[] path3;
                EbmlFloat sf;
                double sampleRate = 8000.0;
                long channelCount = 1L;
                String language = "eng";
                MKVType[] path102 = new MKVType[]{MKVType.TrackEntry, MKVType.CodecID};
                EbmlString codecId2 = (EbmlString)MKVType.findFirst(elemTrack, path102);
                Codec codec2 = codecAudioMapping.get(codecId2.getString());
                if (codec2 == null) {
                    System.out.println("Unknown audio codec: '" + codecId2.getString() + "'");
                }
                if ((sf = (EbmlFloat)MKVType.findFirst(elemTrack, path3 = new MKVType[]{MKVType.TrackEntry, MKVType.Audio, MKVType.SamplingFrequency})) != null) {
                    sampleRate = sf.getDouble();
                }
                if ((channels = (EbmlUint)MKVType.findFirst(elemTrack, path4 = new MKVType[]{MKVType.TrackEntry, MKVType.Audio, MKVType.Channels})) != null) {
                    channelCount = channels.getUint();
                }
                if ((tagLanguage = (EbmlString)MKVType.findFirst(elemTrack, path5 = new MKVType[]{MKVType.TrackEntry, MKVType.Language})) != null) {
                    language = tagLanguage.getString();
                }
                this.aTracks.add(new AudioTrack(this, (int)id, codec2, sampleRate, channelCount, language));
                continue;
            }
            if (type == 3L || type == 16L) continue;
            if (type == 17L) {
                MKVType[] path5;
                EbmlString tagLanguage;
                String language = "eng";
                path10 = new MKVType[]{MKVType.TrackEntry, MKVType.CodecID};
                codecId = (EbmlString)MKVType.findFirst(elemTrack, path10);
                codec = codecSubtitleMapping.get(codecId.getString());
                if (codec == null) {
                    System.out.println("Unknown subtitle codec: '" + codecId.getString() + "'");
                }
                if ((tagLanguage = (EbmlString)MKVType.findFirst(elemTrack, path5 = new MKVType[]{MKVType.TrackEntry, MKVType.Language})) != null) {
                    language = tagLanguage.getString();
                }
                SubtitlesTrack subsTrack = new SubtitlesTrack(this, (int)id, codec, language);
                this.subsTracks.add(subsTrack);
                continue;
            }
            if (type != 18L && type != 32L && type != 33L) continue;
        }
        MKVType[] path2 = new MKVType[]{MKVType.Segment, MKVType.Cluster};
        for (EbmlMaster aCluster : MKVType.findList(this.t, EbmlMaster.class, path2)) {
            MKVType[] path1 = new MKVType[]{MKVType.Cluster, MKVType.Timecode};
            long baseTimecode = ((EbmlUint)MKVType.findFirst(aCluster, path1)).getUint();
            for (EbmlBase child : aCluster.children) {
                if (MKVType.SimpleBlock.equals(child.type)) {
                    MkvBlock b = (MkvBlock)child;
                    b.absoluteTimecode = (long)b.timecode + baseTimecode;
                    this.putIntoRightBasket(b);
                    continue;
                }
                if (!MKVType.BlockGroup.equals(child.type)) continue;
                EbmlMaster group = (EbmlMaster)child;
                for (EbmlBase grandChild : group.children) {
                    if (grandChild.type != MKVType.Block) continue;
                    MkvBlock b = (MkvBlock)grandChild;
                    b.absoluteTimecode = (long)b.timecode + baseTimecode;
                    this.putIntoRightBasket(b);
                }
            }
        }
    }

    private void putIntoRightBasket(MkvBlock b) {
        if (this.vTrack != null && b.trackNumber == (long)this.vTrack.trackNo) {
            this.vTrack.blocks.add(b);
        } else {
            int i;
            for (i = 0; i < this.aTracks.size(); ++i) {
                AudioTrack audio = this.aTracks.get(i);
                if (b.trackNumber != (long)audio.trackNo) continue;
                audio.blocks.add(IndexedBlock.make(audio.framesCount, b));
                audio.framesCount += b.frameSizes.length;
            }
            for (i = 0; i < this.subsTracks.size(); ++i) {
                SubtitlesTrack subs = this.subsTracks.get(i);
                if (b.trackNumber != (long)subs.trackNo) continue;
                subs.blocks.add(IndexedBlock.make(subs.framesCount, b));
                subs.framesCount += b.frameSizes.length;
            }
        }
    }

    public int getPictureWidth() {
        return this.pictureWidth;
    }

    public int getPictureHeight() {
        return this.pictureHeight;
    }

    public List<DemuxerTrack> getAudioTracks() {
        return this.aTracks;
    }

    public List<DemuxerTrack> getTracks() {
        ArrayList<DemuxerTrack> tracks = new ArrayList<DemuxerTrack>(this.aTracks);
        tracks.add((AudioTrack)((Object)this.vTrack));
        tracks.addAll(this.subsTracks);
        return tracks;
    }

    public List<DemuxerTrack> getVideoTracks() {
        ArrayList<DemuxerTrack> tracks = new ArrayList<DemuxerTrack>();
        tracks.add(this.vTrack);
        return tracks;
    }

    public List<DemuxerTrack> getSubtitleTracks() {
        return this.subsTracks;
    }

    public List<? extends EbmlBase> getTree() {
        return this.t;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @UsedViaReflection
    public static int probe(ByteBuffer b) {
        ByteBuffer fork = b.duplicate();
        byte[] firstFour = new byte[4];
        fork.get(firstFour);
        boolean hasEBMLHeader = Arrays.equals(firstFour, MKVType.EBML.id);
        if (hasEBMLHeader) {
            EbmlUtil.VarIntDetail headerLen = EbmlUtil.parseVarInt(fork);
            if (headerLen.value < 0L || headerLen.value > 1000L) {
                return 30;
            }
            byte[] allHeader = new byte[(int)headerLen.value];
            fork.get(allHeader);
            byte[] docTypeID = MKVType.DocType.id;
            int currPos = 0;
            while ((long)currPos < headerLen.value && allHeader[currPos++] != docTypeID[0] && allHeader[currPos++] != docTypeID[1]) {
            }
            if ((long)currPos == headerLen.value) {
                return 45;
            }
            byte[] theTypeLen = new byte[8];
            System.arraycopy(allHeader, currPos, theTypeLen, 0, 8);
            try {
                String[] acceptableDocTypes;
                EbmlUtil.VarIntDetail typeLen = EbmlUtil.parseVarInt(ByteBuffer.wrap(theTypeLen));
                if (typeLen.value < 0L || typeLen.value > 50L) {
                    return 75;
                }
                byte[] theType = new byte[(int)typeLen.value];
                System.arraycopy(allHeader, currPos + typeLen.length, theType, 0, (int)typeLen.value);
                String parsedType = new String(theType);
                for (String acceptableType : acceptableDocTypes = new String[]{"matroska", "webm"}) {
                    if (!acceptableType.equals(parsedType)) continue;
                    return 100;
                }
                return 90;
            }
            catch (RuntimeException rex) {
                try {
                    return 60;
                }
                catch (RuntimeException rex2) {
                    return 15;
                }
            }
        }
        return 0;
    }

    static {
        codecVideoMapping.put("V_MS/VFW/FOURCC", null);
        codecVideoMapping.put("V_UNCOMPRESSED", null);
        codecVideoMapping.put("V_MPEG4/ISO/SP", null);
        codecVideoMapping.put("V_MPEG4/ISO/ASP", null);
        codecVideoMapping.put("V_MPEG4/ISO/AP", null);
        codecVideoMapping.put("V_MPEG4/MS/V3", Codec.MPEG4);
        codecVideoMapping.put("V_MPEG4/ISO/AVC", Codec.H264);
        codecVideoMapping.put("V_MPEGH/ISO/HEVC", Codec.H265);
        codecVideoMapping.put("V_MPEG1", null);
        codecVideoMapping.put("V_MPEG2", Codec.MPEG2);
        codecVideoMapping.put("V_REAL/RV10", null);
        codecVideoMapping.put("V_REAL/RV20", null);
        codecVideoMapping.put("V_REAL/RV30", null);
        codecVideoMapping.put("V_REAL/RV40", null);
        codecVideoMapping.put("V_QUICKTIME", null);
        codecVideoMapping.put("V_THEORA", null);
        codecVideoMapping.put("V_PRORES", null);
        codecVideoMapping.put("V_VP8", Codec.VP8);
        codecVideoMapping.put("V_VP9", Codec.VP9);
        codecVideoMapping.put("V_FFV1", null);
        codecAudioMapping = new HashMap<String, Codec>();
        codecAudioMapping.put("A_MPEG/L3", Codec.MP3);
        codecAudioMapping.put("A_MPEG/L2", null);
        codecAudioMapping.put("A_MPEG/L1", null);
        codecAudioMapping.put("A_PCM/INT/BIG", null);
        codecAudioMapping.put("A_PCM/INT/LIT", null);
        codecAudioMapping.put("A_PCM/FLOAT/IEEE", null);
        codecAudioMapping.put("A_MPC", null);
        codecAudioMapping.put("A_AC3", Codec.AC3);
        codecAudioMapping.put("A_AC3/BSID9", Codec.AC3);
        codecAudioMapping.put("A_AC3/BSID10", Codec.AC3);
        codecAudioMapping.put("A_ALAC", null);
        codecAudioMapping.put("A_DTS", null);
        codecAudioMapping.put("A_DTS/EXPRESS", null);
        codecAudioMapping.put("A_DTS/LOSSLESS", null);
        codecAudioMapping.put("A_VORBIS", Codec.VORBIS);
        codecAudioMapping.put("A_FLAC", null);
        codecAudioMapping.put("A_REAL/14_4", null);
        codecAudioMapping.put("A_REAL/28_8", null);
        codecAudioMapping.put("A_REAL/COOK", null);
        codecAudioMapping.put("A_REAL/SIPR", null);
        codecAudioMapping.put("A_REAL/RALF", null);
        codecAudioMapping.put("A_REAL/ATRC", null);
        codecAudioMapping.put("A_MS/ACM", null);
        codecAudioMapping.put("A_AAC", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG2", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG2/MAIN", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG2/LC", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG2/LC/SBR", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG2/SSR", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG4", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG4/MAIN", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG4/LC", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG4/LC/SBR", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG4/SSR", Codec.AAC);
        codecAudioMapping.put("A_AAC/MPEG4/LTP", Codec.AAC);
        codecAudioMapping.put("A_QUICKTIME", null);
        codecAudioMapping.put("A_QUICKTIME/QDMC", null);
        codecAudioMapping.put("A_QUICKTIME/QDM2", null);
        codecAudioMapping.put("A_TTA1", null);
        codecAudioMapping.put("A_WAVPACK4", null);
        codecAudioMapping.put("A_OPUS", Codec.OPUS);
        codecSubtitleMapping = new HashMap<String, Codec>();
        codecSubtitleMapping.put("S_TEXT/UTF8", Codec.UTF8);
        codecSubtitleMapping.put("S_TEXT/SSA", null);
        codecSubtitleMapping.put("S_TEXT/ASS", null);
        codecSubtitleMapping.put("S_TEXT/USF", null);
        codecSubtitleMapping.put("S_TEXT/WEBVTT", null);
        codecSubtitleMapping.put("S_IMAGE/BMP", null);
        codecSubtitleMapping.put("S_DVBSUB", null);
        codecSubtitleMapping.put("S_VOBSUB", null);
        codecSubtitleMapping.put("S_HDMV/PGS", null);
        codecSubtitleMapping.put("S_HDMV/TEXTST", null);
        codecSubtitleMapping.put("S_KATE", null);
    }

    public static class AudioTrack
    extends MkvTrack {
        private double sampleRate = 8000.0;
        private String language = "eng";
        private long channelCount = 1L;
        private Codec codec = null;

        public AudioTrack(MKVDemuxer demuxer, int trackNo, Codec codec, double sampleRate, long channelCount, String language) {
            super(trackNo, demuxer);
            this.codec = codec;
            if (language != null) {
                this.language = language;
            }
            if (sampleRate > 0.0) {
                this.sampleRate = sampleRate;
            }
            if (channelCount > 0L) {
                this.channelCount = channelCount;
            }
        }

        @Override
        public Packet nextFrame() throws IOException {
            MkvBlockData b = this.nextBlock();
            if (b == null) {
                return null;
            }
            return Packet.createPacket(b.data, b.block.absoluteTimecode, (int)Math.round(this.sampleRate), 1L, 0L, Packet.FrameType.KEY, TapeTimecode.ZERO_TAPE_TIMECODE);
        }

        @Override
        public Packet getFrames(int count) {
            MkvBlockData frameBlock = this.getFrameBlock(count);
            if (frameBlock == null) {
                return null;
            }
            return Packet.createPacket(frameBlock.data, frameBlock.block.absoluteTimecode, (int)Math.round(this.sampleRate), frameBlock.count, 0L, Packet.FrameType.KEY, TapeTimecode.ZERO_TAPE_TIMECODE);
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            boolean isPcm = false;
            if (this.codec != null) {
                isPcm = this.codec.isPcm();
            }
            return new DemuxerTrackMeta(TrackType.AUDIO, this.codec, 0.0, null, 0, null, null, AudioCodecMeta.createAudioCodecMeta("", 0, (int)this.channelCount, (int)this.sampleRate, ByteOrder.LITTLE_ENDIAN, isPcm, null, null));
        }

        @Override
        public boolean gotoSyncFrame(long frame) {
            return this.gotoFrame(frame);
        }

        public String getLanguage() {
            return this.language;
        }

        public long getChannelCount() {
            return this.channelCount;
        }
    }

    public static class MkvTrack
    implements SeekableDemuxerTrack {
        public final int trackNo;
        List<IndexedBlock> blocks = new ArrayList<IndexedBlock>();
        int framesCount = 0;
        private int frameIdx = 0;
        private int blockIdx = 0;
        private int frameInBlockIdx = 0;
        private MKVDemuxer demuxer;

        public MkvTrack(int trackNo, MKVDemuxer demuxer) {
            this.trackNo = trackNo;
            this.demuxer = demuxer;
        }

        @Override
        public Packet nextFrame() throws IOException {
            MkvBlockData bd = this.nextBlock();
            if (bd == null) {
                return null;
            }
            return Packet.createPacket(bd.data, bd.block.absoluteTimecode, this.demuxer.timescale, 1L, this.frameIdx - 1, Packet.FrameType.KEY, TapeTimecode.ZERO_TAPE_TIMECODE);
        }

        protected MkvBlockData nextBlock() throws IOException {
            ByteBuffer data;
            if (this.frameIdx >= this.blocks.size() || this.blockIdx >= this.blocks.size()) {
                return null;
            }
            MkvBlock b = this.blocks.get((int)this.blockIdx).block;
            if (b == null) {
                throw new RuntimeException("Something somewhere went wrong.");
            }
            if (b.frames == null || b.frames.length == 0) {
                this.demuxer.channel.setPosition(b.dataOffset);
                data = ByteBuffer.allocate(b.dataLen);
                this.demuxer.channel.read(data);
                b.readFrames(data);
            }
            data = b.frames[this.frameInBlockIdx].duplicate();
            ++this.frameInBlockIdx;
            ++this.frameIdx;
            if (this.frameInBlockIdx >= b.frames.length) {
                ++this.blockIdx;
                this.frameInBlockIdx = 0;
            }
            return new MkvBlockData(b, data, 1);
        }

        @Override
        public boolean gotoFrame(long i) {
            if (i > Integer.MAX_VALUE) {
                return false;
            }
            if (i > (long)this.framesCount) {
                return false;
            }
            int frameBlockIdx = this.findBlockIndex(i);
            if (frameBlockIdx == -1) {
                return false;
            }
            this.frameIdx = (int)i;
            this.blockIdx = frameBlockIdx;
            this.frameInBlockIdx = (int)i - this.blocks.get((int)this.blockIdx).firstFrameNo;
            return true;
        }

        private int findBlockIndex(long i) {
            for (int blockIndex = 0; blockIndex < this.blocks.size(); ++blockIndex) {
                if (i < (long)this.blocks.get((int)blockIndex).block.frameSizes.length) {
                    return blockIndex;
                }
                i -= (long)this.blocks.get((int)blockIndex).block.frameSizes.length;
            }
            return -1;
        }

        @Override
        public long getCurFrame() {
            return this.frameIdx;
        }

        @Override
        public void seek(double second) {
            throw new RuntimeException("Not implemented yet");
        }

        public Packet getFrames(int count) {
            MkvBlockData frameBlock = this.getFrameBlock(count);
            if (frameBlock == null) {
                return null;
            }
            return Packet.createPacket(frameBlock.data, frameBlock.block.absoluteTimecode, this.demuxer.timescale, frameBlock.count, 0L, Packet.FrameType.KEY, TapeTimecode.ZERO_TAPE_TIMECODE);
        }

        MkvBlockData getFrameBlock(int count) {
            ByteBuffer data;
            if (count + this.frameIdx >= this.framesCount) {
                return null;
            }
            ArrayList<ByteBuffer> packetFrames = new ArrayList<ByteBuffer>();
            MkvBlock firstBlockInAPacket = this.blocks.get((int)this.blockIdx).block;
            while (count > 0) {
                MkvBlock b = this.blocks.get((int)this.blockIdx).block;
                if (b.frames == null || b.frames.length == 0) {
                    try {
                        this.demuxer.channel.setPosition(b.dataOffset);
                        data = ByteBuffer.allocate(b.dataLen);
                        this.demuxer.channel.read(data);
                        b.readFrames(data);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("while reading frames of a Block at offset 0x" + Long.toHexString(b.dataOffset).toUpperCase() + ")", ioe);
                    }
                }
                packetFrames.add(b.frames[this.frameInBlockIdx].duplicate());
                ++this.frameIdx;
                ++this.frameInBlockIdx;
                if (this.frameInBlockIdx >= b.frames.length) {
                    this.frameInBlockIdx = 0;
                    ++this.blockIdx;
                }
                --count;
            }
            int size = 0;
            for (ByteBuffer aFrame : packetFrames) {
                size += aFrame.limit();
            }
            data = ByteBuffer.allocate(size);
            for (ByteBuffer aFrame : packetFrames) {
                data.put(aFrame);
            }
            return new MkvBlockData(firstBlockInAPacket, data, packetFrames.size());
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            return null;
        }

        @Override
        public boolean gotoSyncFrame(long frame) {
            return this.gotoFrame(frame);
        }
    }

    private static class MkvBlockData {
        final MkvBlock block;
        final ByteBuffer data;
        final int count;

        MkvBlockData(MkvBlock block, ByteBuffer data, int count) {
            this.block = block;
            this.data = data;
            this.count = count;
        }
    }

    public static class SubtitlesTrack
    extends MkvTrack {
        private Codec codec = null;
        private String language = "eng";

        SubtitlesTrack(MKVDemuxer demuxer, int trackNo, Codec codec, String language) {
            super(trackNo, demuxer);
            this.codec = codec;
            if (language != null) {
                this.language = language;
            }
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            return new DemuxerTrackMeta(TrackType.TEXT, this.codec, 0.0, null, 0, null, null, null);
        }

        public String getLanguage() {
            return this.language;
        }
    }

    public static class IndexedBlock {
        public int firstFrameNo;
        public MkvBlock block;

        public static IndexedBlock make(int no, MkvBlock b) {
            IndexedBlock ib = new IndexedBlock();
            ib.firstFrameNo = no;
            ib.block = b;
            return ib;
        }
    }

    public static class VideoTrack
    implements SeekableDemuxerTrack {
        private ByteBuffer state;
        public final int trackNo;
        private int frameIdx = 0;
        List<MkvBlock> blocks = new ArrayList<MkvBlock>();
        private MKVDemuxer demuxer;
        private Codec codec;
        private AvcCBox avcC;

        public VideoTrack(MKVDemuxer demuxer, int trackNo, ByteBuffer state, Codec codec) {
            this.demuxer = demuxer;
            this.trackNo = trackNo;
            this.codec = codec;
            if (codec == Codec.H264) {
                this.avcC = H264Utils.parseAVCCFromBuffer(state);
                this.state = H264Utils.avcCToAnnexB(this.avcC);
            } else {
                this.state = state;
            }
        }

        @Override
        public Packet nextFrame() throws IOException {
            if (this.frameIdx >= this.blocks.size()) {
                return null;
            }
            MkvBlock b = this.blocks.get(this.frameIdx);
            if (b == null) {
                throw new RuntimeException("Something somewhere went wrong.");
            }
            ++this.frameIdx;
            this.demuxer.channel.setPosition(b.dataOffset);
            ByteBuffer data = ByteBuffer.allocate(b.dataLen);
            this.demuxer.channel.read(data);
            data.flip();
            b.readFrames(data.duplicate());
            long duration = 1L;
            if (this.frameIdx < this.blocks.size()) {
                duration = this.blocks.get((int)this.frameIdx).absoluteTimecode - b.absoluteTimecode;
            }
            ByteBuffer result = b.frames[0].duplicate();
            if (this.codec == Codec.H264) {
                result = H264Utils.decodeMOVPacket(result, this.avcC);
            }
            return Packet.createPacket(result, b.absoluteTimecode, this.demuxer.timescale, duration, this.frameIdx - 1, b._keyFrame ? Packet.FrameType.KEY : Packet.FrameType.INTER, TapeTimecode.ZERO_TAPE_TIMECODE);
        }

        @Override
        public boolean gotoFrame(long i) {
            if (i > Integer.MAX_VALUE) {
                return false;
            }
            if (i > (long)this.blocks.size()) {
                return false;
            }
            this.frameIdx = (int)i;
            return true;
        }

        @Override
        public long getCurFrame() {
            return this.frameIdx;
        }

        @Override
        public void seek(double second) {
            throw new RuntimeException("Not implemented yet");
        }

        public int getFrameCount() {
            return this.blocks.size();
        }

        public ByteBuffer getCodecState() {
            return this.state;
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            return new DemuxerTrackMeta(TrackType.VIDEO, this.codec, 0.0, null, 0, this.state, VideoCodecMeta.createSimpleVideoCodecMeta(new Size(this.demuxer.pictureWidth, this.demuxer.pictureHeight), ColorSpace.YUV420), null);
        }

        @Override
        public boolean gotoSyncFrame(long i) {
            throw new RuntimeException("Unsupported");
        }
    }
}

