/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.creeperhost.blockshot.repack.org.jcodec.common.Tuple;

public class Chunk {
    public static final int UNEQUAL_DUR = -1;
    public static final int UNEQUAL_SIZES = -1;
    private long offset;
    private long startTv;
    private int sampleCount;
    private int sampleSize;
    private int[] sampleSizes;
    private int sampleDur;
    private int[] sampleDurs;
    private int entry;
    private ByteBuffer data;

    public static Chunk createSameSizeAndDuration(long offset, long tv, int sampleSize, int sampleDuration, int sampleCount) {
        return new Chunk(offset, tv, sampleCount, sampleSize, null, sampleDuration, null, 1);
    }

    public static Chunk createSameSize(long offset, long tv, int sampleSize, int[] sampleDurations) {
        return new Chunk(offset, tv, sampleDurations.length, sampleSize, null, -1, sampleDurations, 1);
    }

    public static Chunk createSameDuration(long offset, long tv, int[] sampleSizes, int sampleDuration) {
        return new Chunk(offset, tv, sampleSizes.length, -1, sampleSizes, sampleDuration, null, 1);
    }

    public static Chunk create(long offset, long tv, int[] sampleSizes, int[] sampleDurations) {
        if (sampleSizes.length != sampleDurations.length) {
            throw new IllegalArgumentException("Sizes and durations array lenghts should match");
        }
        return new Chunk(offset, tv, sampleSizes.length, -1, sampleSizes, -1, sampleDurations, 1);
    }

    Chunk(long offset, long startTv, int sampleCount, int sampleSize, int[] sampleSizes, int sampleDur, int[] sampleDurs, int entry) {
        this.offset = offset;
        this.startTv = startTv;
        this.sampleCount = sampleCount;
        this.sampleSize = sampleSize;
        this.sampleSizes = sampleSizes;
        this.sampleDur = sampleDur;
        this.sampleDurs = sampleDurs;
        this.entry = entry;
    }

    public static Chunk createFrom(Chunk other) {
        return new Chunk(other.getOffset(), other.getStartTv(), other.getSampleCount(), other.getSampleSize(), other.getSampleSizes(), other.getSampleDur(), other.getSampleDurs(), other.getEntry());
    }

    public long getOffset() {
        return this.offset;
    }

    public long getStartTv() {
        return this.startTv;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int[] getSampleSizes() {
        return this.sampleSizes;
    }

    public int getSampleDur() {
        return this.sampleDur;
    }

    public int[] getSampleDurs() {
        return this.sampleDurs;
    }

    public int getEntry() {
        return this.entry;
    }

    public int getDuration() {
        if (this.sampleDur != -1) {
            return this.sampleDur * this.sampleCount;
        }
        int sum = 0;
        for (int j = 0; j < this.sampleDurs.length; ++j) {
            int i = this.sampleDurs[j];
            sum += i;
        }
        return sum;
    }

    public long getSize() {
        if (this.sampleSize != -1) {
            return (long)this.sampleSize * (long)this.sampleCount;
        }
        long sum = 0L;
        for (int j = 0; j < this.sampleSizes.length; ++j) {
            int i = this.sampleSizes[j];
            sum += (long)i;
        }
        return sum;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public void setStartTv(long startTv) {
        this.startTv = startTv;
    }

    public void setSampleSizes(int[] sampleSizes) {
        this.sampleSizes = sampleSizes;
    }

    public Tuple._2<Chunk, Chunk> split(long cutDur, boolean roundUp) {
        int drop = 0;
        long tvOff = 0L;
        long byteOff = 0L;
        for (int s = 0; s < this.sampleCount; ++s) {
            long size;
            long dur = this.sampleDur == -1 ? (long)this.sampleDurs[s] : (long)this.sampleDur;
            long l = size = this.sampleSize == -1 ? (long)this.sampleSizes[s] : (long)this.sampleSize;
            if (dur > cutDur && !roundUp) break;
            ++drop;
            tvOff += dur;
            byteOff += size;
            if ((cutDur -= dur) < 0L) break;
        }
        Chunk left = new Chunk(this.offset, this.startTv, drop, this.sampleSize, this.sampleSizes == null ? null : Arrays.copyOfRange(this.sampleSizes, 0, drop), this.sampleDur, this.sampleDurs == null ? null : Arrays.copyOfRange(this.sampleDurs, 0, drop), this.entry);
        Chunk right = new Chunk(this.offset + byteOff, this.startTv + tvOff, this.sampleCount - drop, this.sampleSize, this.sampleSizes == null ? null : Arrays.copyOfRange(this.sampleSizes, drop, this.sampleSizes.length), this.sampleDur, this.sampleDurs == null ? null : Arrays.copyOfRange(this.sampleDurs, drop, this.sampleDurs.length), this.entry);
        return new Tuple._2<Chunk, Chunk>(left, right);
    }

    public void unpackDurations() {
        if (this.sampleDur == -1) {
            return;
        }
        this.sampleDurs = new int[this.sampleCount];
        Arrays.fill(this.sampleDurs, this.sampleDur);
        this.sampleDur = -1;
    }

    public void unpackSampleSizes() {
        if (this.sampleSize == -1) {
            return;
        }
        this.sampleSizes = new int[this.sampleCount];
        Arrays.fill(this.sampleSizes, this.sampleSize);
        this.sampleSize = -1;
    }

    public void trimLastSample(long l) {
        if (l == 0L) {
            return;
        }
        if (this.sampleCount == 0) {
            throw new IllegalStateException("Trimming empty chunk");
        }
        if (this.sampleDur != -1) {
            this.unpackDurations();
        }
        if ((long)this.sampleDurs[this.sampleCount - 1] < l) {
            throw new IllegalArgumentException("Trimming more then one sample duration");
        }
        int n = this.sampleCount - 1;
        this.sampleDurs[n] = (int)((long)this.sampleDurs[n] - l);
    }

    public void trimFirstSample(long l) {
        if (l == 0L) {
            return;
        }
        if (this.sampleCount == 0) {
            throw new IllegalStateException("Trimming empty chunk");
        }
        if (this.sampleDur != -1) {
            this.unpackDurations();
        }
        if ((long)this.sampleDurs[0] < l) {
            throw new IllegalArgumentException("Trimming more then one sample duration");
        }
        this.sampleDurs[0] = (int)((long)this.sampleDurs[0] - l);
        this.startTv += l;
    }
}

