/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.creeperhost.blockshot.repack.org.jcodec.api.JCodecException;
import net.creeperhost.blockshot.repack.org.jcodec.common.XMLMapper;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Rational;

public class MPDModel {
    public static MPD parse(URL url) throws IOException, JCodecException {
        try {
            return XMLMapper.map(url.openStream(), MPD.class, new TypeHandler1());
        }
        catch (ReflectiveOperationException e) {
            throw new JCodecException(e);
        }
        catch (XMLStreamException e) {
            throw new JCodecException(e);
        }
    }

    public static class SegmentURL {
        public String media;
    }

    public static class Initialization {
        public String sourceURL;
    }

    public static class SegmentList {
        public int duration;
        public Initialization initialization;
        public List<SegmentURL> segmentUrls = new LinkedList<SegmentURL>();

        public void addSegmentURL(SegmentURL arg) {
            this.segmentUrls.add(arg);
        }
    }

    public static class SegmentBase {
        public String indexRange;
    }

    public static class Representation {
        public String id;
        public String mimeType;
        public String codecs;
        public int width;
        public int height;
        public Rational frameRate;
        public Rational sar;
        public int startWithSAP;
        public int bandwidth;
        public int audioSamplingRate;
        public String baseURL;
        public SegmentTemplate segmentTemplate;
        public SegmentBase segmentBase;
        public SegmentList segmentList;
    }

    public static class SegmentTemplate {
        public int timescale;
        public int duration;
        public String media;
        public int startNumber;
        public String initialization;
    }

    public static class AdaptationSet {
        public boolean segmentAlignment;
        public int maxWidth;
        public int maxHeight;
        public Rational maxFrameRate;
        public Rational par;
        public SegmentTemplate segmentTemplate;
        public List<Representation> representations = new LinkedList<Representation>();

        public void addRepresentation(Representation arg) {
            this.representations.add(arg);
        }
    }

    public static class Period {
        public Time start;
        public Time duration;
        public List<AdaptationSet> adaptationSets = new LinkedList<AdaptationSet>();

        public void addAdaptationSet(AdaptationSet arg) {
            this.adaptationSets.add(arg);
        }
    }

    public static class MPD {
        public Time mediaPresentationDuration;
        public List<Period> periods = new LinkedList<Period>();

        public void addPeriod(Period arg) {
            this.periods.add(arg);
        }
    }

    public static class TypeHandler1
    implements XMLMapper.TypeHandler {
        @Override
        public Object parse(String value, Class<?> clz) {
            if (clz == Time.class) {
                return Time.parseTime(value);
            }
            return null;
        }

        @Override
        public boolean supports(Class<?> clz) {
            return clz == Time.class;
        }
    }

    public static class Time {
        public double sec;

        public Time(double sec) {
            this.sec = sec;
        }

        public static Time parseTime(String arg) {
            char[] charArray = arg.toCharArray();
            if (charArray.length < 3 || charArray[0] != 'P' || charArray[1] != 'T') {
                return null;
            }
            int tokenStart = 2;
            double sec = 0.0;
            block5: for (int i = 2; i < charArray.length; ++i) {
                if (charArray[i] != 'S' && charArray[i] != 'M' && (charArray[i] != 'H' || tokenStart == i)) continue;
                String token = new String(charArray, tokenStart, i - tokenStart);
                double parseDouble = Double.parseDouble(token);
                tokenStart = i + 1;
                switch (charArray[i]) {
                    case 'S': {
                        sec += parseDouble;
                        continue block5;
                    }
                    case 'M': {
                        sec += parseDouble * 60.0;
                        continue block5;
                    }
                    case 'H': {
                        sec += parseDouble * 3600.0;
                    }
                }
            }
            return new Time(sec);
        }

        public double getSec() {
            return this.sec;
        }
    }
}

