/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.FullBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;

public class BitRateBox
extends FullBox {
    private int bufferSizeDB;
    private int maxBitrate;
    private int avgBitrate;

    public static BitRateBox createUriBox(int bufferSizeDB, int maxBitrate, int avgBitrate) {
        BitRateBox box = new BitRateBox(new Header(BitRateBox.fourcc()));
        box.bufferSizeDB = bufferSizeDB;
        box.maxBitrate = maxBitrate;
        box.avgBitrate = avgBitrate;
        return box;
    }

    public BitRateBox(Header atom) {
        super(atom);
    }

    @Override
    public int estimateSize() {
        return 24;
    }

    public static String fourcc() {
        return "btrt";
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.bufferSizeDB = input.getInt();
        this.maxBitrate = input.getInt();
        this.avgBitrate = input.getInt();
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.bufferSizeDB);
        out.putInt(this.maxBitrate);
        out.putInt(this.avgBitrate);
    }

    public int getBufferSizeDB() {
        return this.bufferSizeDB;
    }

    public int getMaxBitrate() {
        return this.maxBitrate;
    }

    public int getAvgBitrate() {
        return this.avgBitrate;
    }
}

