/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.common.JCodecUtil2;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.FullBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;

public class HandlerBox
extends FullBox {
    private String componentType;
    private String componentSubType;
    private String componentManufacturer;
    private int componentFlags;
    private int componentFlagsMask;
    private String componentName;

    public HandlerBox(Header atom) {
        super(atom);
    }

    public static String fourcc() {
        return "hdlr";
    }

    public static HandlerBox createHandlerBox(String componentType, String componentSubType, String componentManufacturer, int componentFlags, int componentFlagsMask) {
        HandlerBox hdlr = new HandlerBox(new Header(HandlerBox.fourcc()));
        hdlr.componentType = componentType;
        hdlr.componentSubType = componentSubType;
        hdlr.componentManufacturer = componentManufacturer;
        hdlr.componentFlags = componentFlags;
        hdlr.componentFlagsMask = componentFlagsMask;
        hdlr.componentName = "";
        return hdlr;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.componentType = NIOUtils.readString(input, 4);
        this.componentSubType = NIOUtils.readString(input, 4);
        this.componentManufacturer = NIOUtils.readString(input, 4);
        this.componentFlags = input.getInt();
        this.componentFlagsMask = input.getInt();
        this.componentName = NIOUtils.readString(input, input.remaining());
    }

    @Override
    public void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.put(this.fourcc(this.componentType));
        out.put(this.fourcc(this.componentSubType));
        out.put(this.fourcc(this.componentManufacturer));
        out.putInt(this.componentFlags);
        out.putInt(this.componentFlagsMask);
        if (this.componentName != null) {
            out.put(this.fourcc(this.componentName));
        }
    }

    public byte[] fourcc(String fourcc) {
        byte[] dst = new byte[4];
        if (fourcc != null) {
            byte[] tmp = JCodecUtil2.asciiString(fourcc);
            for (int i = 0; i < Math.min(tmp.length, 4); ++i) {
                dst[i] = tmp[i];
            }
        }
        return dst;
    }

    @Override
    public int estimateSize() {
        return 32 + (this.componentName != null ? 4 : 0);
    }

    @Box.AtomField(idx=0)
    public String getComponentType() {
        return this.componentType;
    }

    @Box.AtomField(idx=1)
    public String getComponentSubType() {
        return this.componentSubType;
    }

    @Box.AtomField(idx=2)
    public String getComponentManufacturer() {
        return this.componentManufacturer;
    }

    @Box.AtomField(idx=3)
    public int getComponentFlags() {
        return this.componentFlags;
    }

    @Box.AtomField(idx=4)
    public int getComponentFlagsMask() {
        return this.componentFlagsMask;
    }
}

