/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.TimeUtil;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.FullBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;

public class MediaHeaderBox
extends FullBox {
    private long created;
    private long modified;
    private int timescale;
    private long duration;
    private int language;
    private int quality;

    public MediaHeaderBox(Header atom) {
        super(atom);
    }

    public static String fourcc() {
        return "mdhd";
    }

    public static MediaHeaderBox createMediaHeaderBox(int timescale, long duration, int language, long created, long modified, int quality) {
        MediaHeaderBox mdhd = new MediaHeaderBox(new Header(MediaHeaderBox.fourcc()));
        mdhd.timescale = timescale;
        mdhd.duration = duration;
        mdhd.language = language;
        mdhd.created = created;
        mdhd.modified = modified;
        mdhd.quality = quality;
        return mdhd;
    }

    @Box.AtomField(idx=2)
    public int getTimescale() {
        return this.timescale;
    }

    @Box.AtomField(idx=3)
    public long getDuration() {
        return this.duration;
    }

    @Box.AtomField(idx=0)
    public long getCreated() {
        return this.created;
    }

    @Box.AtomField(idx=1)
    public long getModified() {
        return this.modified;
    }

    @Box.AtomField(idx=4)
    public int getLanguage() {
        return this.language;
    }

    @Box.AtomField(idx=5)
    public int getQuality() {
        return this.quality;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setTimescale(int timescale) {
        this.timescale = timescale;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        if (this.version == 0) {
            this.created = TimeUtil.fromMovTime(input.getInt());
            this.modified = TimeUtil.fromMovTime(input.getInt());
            this.timescale = input.getInt();
            this.duration = (long)input.getInt() & 0xFFFFFFFFL;
        } else if (this.version == 1) {
            this.created = TimeUtil.fromMovTime((int)input.getLong());
            this.modified = TimeUtil.fromMovTime((int)input.getLong());
            this.timescale = input.getInt();
            this.duration = input.getLong();
        } else {
            throw new RuntimeException("Unsupported version");
        }
        this.language = input.getShort();
        this.quality = input.getShort();
    }

    @Override
    public void doWrite(ByteBuffer out) {
        super.doWrite(out);
        if (this.version == 0) {
            out.putInt(TimeUtil.toMovTime(this.created));
            out.putInt(TimeUtil.toMovTime(this.modified));
            out.putInt(this.timescale);
            out.putInt((int)this.duration);
        } else if (this.version == 1) {
            out.putLong(TimeUtil.toMovTime(this.created));
            out.putLong(TimeUtil.toMovTime(this.modified));
            out.putInt(this.timescale);
            out.putLong(this.duration);
        }
        out.putShort((short)this.language);
        out.putShort((short)this.quality);
    }

    @Override
    public int estimateSize() {
        return 32;
    }
}

