/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.FullBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;

public class SyncSamplesBox
extends FullBox {
    public static final String STSS = "stss";
    protected int[] syncSamples;

    public static SyncSamplesBox createSyncSamplesBox(int[] array) {
        SyncSamplesBox stss = new SyncSamplesBox(new Header(STSS));
        stss.syncSamples = array;
        return stss;
    }

    public SyncSamplesBox(Header header) {
        super(header);
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        int len = input.getInt();
        this.syncSamples = new int[len];
        for (int i = 0; i < len; ++i) {
            this.syncSamples[i] = input.getInt();
        }
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.syncSamples.length);
        for (int i = 0; i < this.syncSamples.length; ++i) {
            out.putInt(this.syncSamples[i]);
        }
    }

    @Override
    public int estimateSize() {
        return 16 + this.syncSamples.length * 4;
    }

    public int[] getSyncSamples() {
        return this.syncSamples;
    }
}

