/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.FullBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public class TextConfigBox
extends FullBox {
    private String textConfig;

    public TextConfigBox(Header atom) {
        super(atom);
    }

    public static String fourcc() {
        return "txtC";
    }

    public static TextConfigBox createTextConfigBox(String textConfig) {
        TextConfigBox box = new TextConfigBox(new Header(TextConfigBox.fourcc()));
        box.textConfig = textConfig;
        return box;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.textConfig = NIOUtils.readNullTermStringCharset(input, "UTF-8");
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        NIOUtils.writeNullTermString(out, this.textConfig);
    }

    @Override
    public int estimateSize() {
        return 13 + Platform.getBytesForCharset(this.textConfig, "UTF-8").length;
    }

    public String getTextConfig() {
        return this.textConfig;
    }
}

