/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.FullBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;

public class TimeToSampleBox
extends FullBox {
    private TimeToSampleEntry[] entries;

    public TimeToSampleBox(Header atom) {
        super(atom);
    }

    public static String fourcc() {
        return "stts";
    }

    public static TimeToSampleBox createTimeToSampleBox(TimeToSampleEntry[] timeToSamples) {
        TimeToSampleBox box = new TimeToSampleBox(new Header(TimeToSampleBox.fourcc()));
        box.entries = timeToSamples;
        return box;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        int foo = input.getInt();
        this.entries = new TimeToSampleEntry[foo];
        for (int i = 0; i < foo; ++i) {
            this.entries[i] = new TimeToSampleEntry(input.getInt(), input.getInt());
        }
    }

    @Box.AtomField(idx=0)
    public TimeToSampleEntry[] getEntries() {
        return this.entries;
    }

    @Override
    public void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.entries.length);
        for (int i = 0; i < this.entries.length; ++i) {
            TimeToSampleEntry timeToSampleEntry = this.entries[i];
            out.putInt(timeToSampleEntry.getSampleCount());
            out.putInt(timeToSampleEntry.getSampleDuration());
        }
    }

    @Override
    public int estimateSize() {
        return 16 + this.entries.length * 8;
    }

    public void setEntries(TimeToSampleEntry[] entries) {
        this.entries = entries;
    }

    public static class TimeToSampleEntry {
        int sampleCount;
        int sampleDuration;

        public TimeToSampleEntry(int sampleCount, int sampleDuration) {
            this.sampleCount = sampleCount;
            this.sampleDuration = sampleDuration;
        }

        @Box.AtomField(idx=0)
        public int getSampleCount() {
            return this.sampleCount;
        }

        @Box.AtomField(idx=1)
        public int getSampleDuration() {
            return this.sampleDuration;
        }

        public void setSampleDuration(int sampleDuration) {
            this.sampleDuration = sampleDuration;
        }

        public void setSampleCount(int sampleCount) {
            this.sampleCount = sampleCount;
        }

        public long getSegmentDuration() {
            return this.sampleCount * this.sampleDuration;
        }
    }
}

