/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.common.Demuxer;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrackMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.SeekableDemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.TrackType;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.CodecMP4DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.DashMP4DemuxerTrack;

public class DashMP4Demuxer
implements Demuxer {
    private List<SeekableDemuxerTrack> tracks = new LinkedList<SeekableDemuxerTrack>();

    public static Builder builder() {
        return new Builder();
    }

    private DashMP4Demuxer(List<List<File>> files) throws IOException {
        for (List<File> file : files) {
            this.tracks.add(new CodecMP4DemuxerTrack(DashMP4DemuxerTrack.createFromFiles(file)));
        }
    }

    public DemuxerTrack getVideoTrack() {
        for (SeekableDemuxerTrack demuxerTrack : this.tracks) {
            DemuxerTrackMeta meta = demuxerTrack.getMeta();
            if (meta.getType() != TrackType.VIDEO) continue;
            return demuxerTrack;
        }
        return null;
    }

    public List<DemuxerTrack> getTracks() {
        return new ArrayList<DemuxerTrack>(this.tracks);
    }

    public List<DemuxerTrack> getVideoTracks() {
        ArrayList<DemuxerTrack> result = new ArrayList<DemuxerTrack>();
        for (SeekableDemuxerTrack demuxerTrack : this.tracks) {
            DemuxerTrackMeta meta = demuxerTrack.getMeta();
            if (meta.getType() != TrackType.VIDEO) continue;
            result.add(demuxerTrack);
        }
        return result;
    }

    public List<DemuxerTrack> getAudioTracks() {
        ArrayList<DemuxerTrack> result = new ArrayList<DemuxerTrack>();
        for (SeekableDemuxerTrack demuxerTrack : this.tracks) {
            DemuxerTrackMeta meta = demuxerTrack.getMeta();
            if (meta.getType() != TrackType.AUDIO) continue;
            result.add(demuxerTrack);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        for (SeekableDemuxerTrack track : this.tracks) {
            ((Closeable)((Object)((CodecMP4DemuxerTrack)track).getOther())).close();
        }
    }

    public static void main(String[] args) throws IOException {
        Packet nextFrame;
        DashMP4Demuxer demuxer = DashMP4Demuxer.builder().addTrack().addPattern(args[0]).done().addTrack().addPattern(args[1]).done().build();
        DemuxerTrack videoTrack = demuxer.getVideoTrack();
        DemuxerTrackMeta meta = videoTrack.getMeta();
        System.out.println("Total frames: " + meta.getTotalFrames());
        while ((nextFrame = videoTrack.nextFrame()) != null) {
            System.out.println(nextFrame.getPts());
        }
    }

    public static class TrackBuilder {
        private Builder builder;
        private List<File> list = new LinkedList<File>();

        public TrackBuilder(Builder builder) {
            this.builder = builder;
        }

        public TrackBuilder addPattern(String pattern) {
            String name;
            File file;
            int i = 0;
            while ((file = new File(name = String.format(pattern, i))).exists()) {
                this.list.add(file);
                ++i;
            }
            return this;
        }

        public TrackBuilder addFile(File file) {
            this.list.add(file);
            return this;
        }

        public Builder done() {
            return this.builder;
        }
    }

    public static class Builder {
        List<TrackBuilder> tracks = new ArrayList<TrackBuilder>();

        public TrackBuilder addTrack() {
            TrackBuilder ret = new TrackBuilder(this);
            this.tracks.add(ret);
            return ret;
        }

        public DashMP4Demuxer build() throws IOException {
            LinkedList<List> list = new LinkedList<List>();
            for (TrackBuilder trackBuilder : this.tracks) {
                list.add(trackBuilder.list);
            }
            return new DashMP4Demuxer(list);
        }
    }
}

