/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.aac.AACUtils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.H264Utils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model.SeqParameterSet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.mp4.AvcCBox;
import net.creeperhost.blockshot.repack.org.jcodec.common.ArrayUtil;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.Codec;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrackMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.SeekableDemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.TrackType;
import net.creeperhost.blockshot.repack.org.jcodec.common.VideoCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.FileChannelWrapper;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.ColorSpace;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Packet;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4TrackType;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Util;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieFragmentBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.PixelAspectExt;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrackFragmentBaseMediaDecodeTimeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrackFragmentBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrunBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.MP4DemuxerTrackMeta;

public class DashMP4DemuxerTrack
implements SeekableDemuxerTrack,
Closeable {
    private int[][] sizes;
    private int[][] compOffsets;
    private long[] chunkOffsets;
    private int[] avgDur;
    private int[][] sampleDurations;
    private long offInChunk;
    private SeekableByteChannel[] inputs;
    private int curFrame;
    private int curFrag;
    private long globalFrame;
    private long pts;
    private int frameCount;
    private long totalDuration;
    private TrakBox trak;
    private SampleEntry[] sampleEntries;
    private double durationHint;

    public DashMP4DemuxerTrack(MovieBox mov, TrakBox trak, Fragment[] fragments) {
        long prevOffset = 0L;
        int prevSampleCount = 0;
        this.sizes = new int[fragments.length][];
        this.compOffsets = new int[fragments.length][];
        this.chunkOffsets = new long[fragments.length];
        this.avgDur = new int[fragments.length];
        this.sampleDurations = new int[fragments.length][];
        this.trak = trak;
        this.inputs = new SeekableByteChannel[fragments.length];
        this.sampleEntries = (SampleEntry[])NodeBox.findAllPath((Box)trak, SampleEntry.class, (String[])new String[]{"mdia", "minf", "stbl", "stsd", null});
        if (this.sortable(fragments)) {
            Arrays.sort(fragments, 0, fragments.length, new FragmentComparator());
        }
        int i = 0;
        for (Fragment fragment : fragments) {
            TrackFragmentBox frag = fragment.frag;
            TrunBox trun = frag.getTrun();
            TrackFragmentBaseMediaDecodeTimeBox tfdt = frag.getTfdt();
            if (tfdt != null) {
                if (i > 0) {
                    this.avgDur[i - 1] = (int)((tfdt.getBaseMediaDecodeTime() - prevOffset) / (long)prevSampleCount);
                    this.totalDuration = tfdt.getBaseMediaDecodeTime();
                }
                prevOffset = tfdt.getBaseMediaDecodeTime();
            }
            prevSampleCount = (int)trun.getSampleCount();
            this.sizes[i] = trun.getSampleSizes();
            this.compOffsets[i] = trun.getSampleCompositionOffsets();
            this.chunkOffsets[i] = fragment.offset + frag.getTfhd().getBaseDataOffset() + frag.getTrun().getDataOffset();
            if (trun.isSampleDurationAvailable()) {
                this.sampleDurations[i] = trun.getSampleDurations();
                this.totalDuration += (long)ArrayUtil.sumInt(this.sampleDurations[i]);
            }
            this.frameCount += this.sizes[i].length;
            this.inputs[i] = fragment.input;
            ++i;
        }
        if (this.avgDur.length > 1) {
            this.avgDur[this.avgDur.length - 1] = this.avgDur[this.avgDur.length - 2];
            this.totalDuration += (long)(this.avgDur[this.avgDur.length - 1] * prevSampleCount);
        }
    }

    private boolean sortable(Fragment[] fragments) {
        for (Fragment fragment : fragments) {
            if (fragment.frag.getTfdt() != null) continue;
            return false;
        }
        return true;
    }

    public static DashMP4DemuxerTrack createFromFiles(List<File> files) throws IOException {
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        MovieBox moov = null;
        for (File file : files) {
            FileChannelWrapper channel = NIOUtils.readableChannel(file);
            for (MP4Util.Atom atom : MP4Util.getRootAtoms(channel)) {
                if ("moov".equals(atom.getHeader().getFourcc())) {
                    moov = (MovieBox)atom.parseBox(channel);
                    continue;
                }
                if (!"moof".equalsIgnoreCase(atom.getHeader().getFourcc())) continue;
                MovieFragmentBox mfra = (MovieFragmentBox)atom.parseBox(channel);
                TrackFragmentBox tfra = mfra.getTracks()[0];
                fragments.add(new Fragment(tfra, atom.getOffset(), channel));
            }
        }
        return new DashMP4DemuxerTrack(moov, moov.getTracks()[0], fragments.toArray(new Fragment[0]));
    }

    @Override
    public synchronized MP4Packet nextFrame() throws IOException {
        if (this.curFrag >= this.sizes.length) {
            return null;
        }
        if (this.curFrame >= this.sizes[this.curFrag].length) {
            ++this.curFrag;
            this.curFrame = 0;
            this.offInChunk = 0L;
        }
        if (this.curFrag >= this.sizes.length) {
            return null;
        }
        int size = this.sizes[this.curFrag][this.curFrame];
        return this.getNextFrame(ByteBuffer.allocate(size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer readPacketData(SeekableByteChannel input, ByteBuffer buffer, long offset, int size) throws IOException {
        ByteBuffer result = buffer.duplicate();
        SeekableByteChannel seekableByteChannel = input;
        synchronized (seekableByteChannel) {
            input.setPosition(offset);
            NIOUtils.readL(input, result, size);
        }
        result.flip();
        return result;
    }

    public synchronized MP4Packet getNextFrame(ByteBuffer storage) throws IOException {
        if (this.curFrag >= this.sizes.length) {
            return null;
        }
        if (this.curFrame >= this.sizes[this.curFrag].length) {
            return null;
        }
        int size = this.sizes[this.curFrag][this.curFrame];
        if (storage != null && storage.remaining() < size) {
            throw new IllegalArgumentException("Buffer size is not enough to fit a packet");
        }
        long pktPos = this.chunkOffsets[this.curFrag] + this.offInChunk;
        ByteBuffer result = this.readPacketData(this.inputs[this.curFrag], storage, pktPos, size);
        if (result != null && result.remaining() < size) {
            return null;
        }
        int hintedDuration = (int)(this.durationHint * (double)this.trak.getTimescale() / (double)this.frameCount);
        int duration = this.sampleDurations[this.curFrag] == null ? (this.avgDur[this.curFrag] == 0 ? hintedDuration : this.avgDur[this.curFrag]) : this.sampleDurations[this.curFrag][this.curFrame];
        boolean sync = this.curFrame == 0;
        long realPts = this.pts;
        if (this.compOffsets[this.curFrag] != null) {
            realPts = this.pts + (long)this.compOffsets[this.curFrag][this.curFrame];
        }
        Packet.FrameType ftype = sync ? Packet.FrameType.KEY : Packet.FrameType.INTER;
        MP4Packet pkt = new MP4Packet(result, realPts, this.trak.getTimescale(), duration, this.globalFrame, ftype, null, 0, realPts, 1, pktPos, size, false);
        this.offInChunk += (long)size;
        this.pts += (long)duration;
        ++this.curFrame;
        ++this.globalFrame;
        return pkt;
    }

    @Override
    public DemuxerTrackMeta getMeta() {
        MP4TrackType type = TrakBox.getTrackType(this.trak);
        TrackType t = type == MP4TrackType.VIDEO ? TrackType.VIDEO : (type == MP4TrackType.SOUND ? TrackType.AUDIO : TrackType.OTHER);
        int[] seekFrames = new int[this.sizes.length];
        int numFrames = 0;
        for (int i = 0; i < this.sizes.length; ++i) {
            seekFrames[i] = numFrames;
            numFrames += this.sizes[i].length;
        }
        ByteBuffer codecPrivate = this.getCodecPrivate();
        VideoCodecMeta videoCodecMeta = this.getVideoCodecMeta();
        AudioCodecMeta audioCodecMeta = this.getAudioCodecMeta();
        Codec codec = Codec.codecByFourcc(this.sampleEntries[0].getFourcc());
        ByteBuffer opaque = MP4DemuxerTrackMeta.getCodecPrivateOpaque(codec, this.sampleEntries[0]);
        return new MP4DemuxerTrackMeta(t, codec, this.totalDuration, seekFrames, this.frameCount, codecPrivate, videoCodecMeta, audioCodecMeta, this.sampleEntries, opaque);
    }

    protected ColorSpace getColorInfo() {
        AvcCBox avcC;
        List<ByteBuffer> spsList;
        Codec codec = Codec.codecByFourcc(this.trak.getFourcc());
        if (codec == Codec.H264 && (spsList = (avcC = H264Utils.parseAVCC((VideoSampleEntry)this.sampleEntries[0])).getSpsList()).size() > 0) {
            SeqParameterSet sps = SeqParameterSet.read(spsList.get(0).duplicate());
            return sps.getChromaFormatIdc();
        }
        return null;
    }

    private AudioCodecMeta getAudioCodecMeta() {
        MP4TrackType type = TrakBox.getTrackType(this.trak);
        AudioCodecMeta audioCodecMeta = null;
        if (type == MP4TrackType.SOUND) {
            AudioSampleEntry ase = (AudioSampleEntry)this.sampleEntries[0];
            audioCodecMeta = AudioCodecMeta.fromAudioFormat(ase.getFormat());
        }
        return audioCodecMeta;
    }

    private VideoCodecMeta getVideoCodecMeta() {
        MP4TrackType type = TrakBox.getTrackType(this.trak);
        VideoCodecMeta videoCodecMeta = null;
        if (type == MP4TrackType.VIDEO) {
            videoCodecMeta = VideoCodecMeta.createSimpleVideoCodecMeta(this.trak.getCodedSize(), this.getColorInfo());
            PixelAspectExt pasp = NodeBox.findFirst(this.sampleEntries[0], PixelAspectExt.class, "pasp");
            if (pasp != null) {
                videoCodecMeta.setPixelAspectRatio(pasp.getRational());
            }
        }
        return videoCodecMeta;
    }

    public ByteBuffer getCodecPrivate() {
        Codec codec = Codec.codecByFourcc(this.sampleEntries[0].getFourcc());
        if (codec == Codec.H264) {
            AvcCBox avcC = H264Utils.parseAVCC((VideoSampleEntry)this.sampleEntries[0]);
            return H264Utils.avcCToAnnexB(avcC);
        }
        if (codec == Codec.AAC) {
            return AACUtils.getCodecPrivate(this.sampleEntries[0]);
        }
        return null;
    }

    @Override
    public boolean gotoFrame(long frameNo) throws IOException {
        int curFrag = 0;
        int globalFrame = 0;
        int pts = 0;
        for (int[] is : this.sizes) {
            if (frameNo > (long)is.length) {
                frameNo -= (long)is.length;
                pts += this.sampleDurations[curFrag] == null ? this.avgDur[curFrag] * is.length : ArrayUtil.sumInt(this.sampleDurations[curFrag]);
                ++curFrag;
                globalFrame += is.length;
                continue;
            }
            pts = (int)((long)pts + (this.sampleDurations[curFrag] == null ? (long)this.avgDur[curFrag] * frameNo : (long)ArrayUtil.sumInt3(this.sampleDurations[curFrag], 0, (int)frameNo)));
            this.curFrag = curFrag;
            this.curFrame = (int)frameNo;
            this.globalFrame = (long)globalFrame + frameNo;
            this.pts = pts;
            this.adjustOff();
            return true;
        }
        return false;
    }

    private void adjustOff() {
        this.offInChunk = 0L;
        for (int i = 0; i < this.curFrame; ++i) {
            this.offInChunk += (long)this.sizes[this.curFrag][i];
        }
    }

    @Override
    public long getCurFrame() {
        return this.globalFrame;
    }

    @Override
    public void seek(double second) throws IOException {
        int curFrag = 0;
        int globalFrame = 0;
        int pts = 0;
        for (int[] is : this.sizes) {
            int fragDur;
            int n = fragDur = this.sampleDurations[curFrag] != null ? ArrayUtil.sumInt(this.sampleDurations[curFrag]) : this.avgDur[curFrag] * is.length;
            if (second > (double)fragDur) {
                second -= (double)fragDur;
                pts += fragDur;
                ++curFrag;
                globalFrame += is.length;
                continue;
            }
            this.curFrag = curFrag;
            if (this.sampleDurations[curFrag] != null) {
                this.curFrame = 0;
                while (this.curFrame < this.sampleDurations[curFrag].length && !(second < (double)this.sampleDurations[curFrag][this.curFrame])) {
                    second -= (double)this.sampleDurations[curFrag][this.curFrame];
                    ++this.curFrame;
                }
            } else {
                this.curFrame = (int)(second / (double)this.avgDur[this.curFrag]);
                this.adjustOff();
            }
            pts += this.sampleDurations[curFrag] == null ? this.avgDur[curFrag] * this.curFrame : ArrayUtil.sumInt3(this.sampleDurations[curFrag], 0, this.curFrame);
            this.globalFrame = globalFrame + this.curFrame;
        }
    }

    @Override
    public boolean gotoSyncFrame(long frameNo) throws IOException {
        int curFrag = 0;
        int globalFrame = 0;
        int pts = 0;
        for (int[] is : this.sizes) {
            if (frameNo > (long)is.length) {
                frameNo -= (long)is.length;
                pts += this.sampleDurations[curFrag] == null ? this.avgDur[curFrag] * is.length : ArrayUtil.sumInt(this.sampleDurations[curFrag]);
                ++curFrag;
                globalFrame += is.length;
                continue;
            }
            this.curFrag = curFrag;
            this.curFrame = 0;
            this.globalFrame = globalFrame;
            this.pts = pts;
            this.offInChunk = 0L;
            return true;
        }
        return false;
    }

    public MP4TrackType getTrackType() {
        return TrakBox.getTrackType(this.trak);
    }

    @Override
    public void close() throws IOException {
        IOException ex = null;
        for (SeekableByteChannel channel : this.inputs) {
            try {
                channel.close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public int getNo() {
        return this.trak.getTrackHeader().getTrackId();
    }

    public void setDurationHint(double arg) {
        this.durationHint = arg;
    }

    public static class FragmentComparator
    implements Comparator<Fragment> {
        @Override
        public int compare(Fragment arg0, Fragment arg1) {
            long b;
            long a = arg0.frag.getTfdt() == null ? 0L : arg0.frag.getTfdt().getBaseMediaDecodeTime();
            long l = b = arg1.frag.getTfdt() == null ? 0L : arg1.frag.getTfdt().getBaseMediaDecodeTime();
            return a < b ? -1 : (a == b ? 0 : 1);
        }
    }

    public static class Fragment {
        TrackFragmentBox frag;
        long offset;
        SeekableByteChannel input;

        public Fragment(TrackFragmentBox frag, long offset, SeekableByteChannel input) {
            this.frag = frag;
            this.offset = offset;
            this.input = input;
        }
    }
}

