/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.creeperhost.blockshot.repack.org.jcodec.api.JCodecException;
import net.creeperhost.blockshot.repack.org.jcodec.common.Demuxer;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrackMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.SeekableDemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.TrackType;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Packet;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MPDModel;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.CodecMP4DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.DashMP4DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.MP4DemuxerTrackMeta;

public class DashStreamDemuxer
implements Demuxer {
    private List<DashStreamDemuxerTrack> tracks;
    private List<SeekableDemuxerTrack> coded;
    private URL url;
    private MPDModel.MPD mpd;
    public static int INIT_SIZE = 3;

    public DashStreamDemuxer(URL url) throws IOException {
        this.url = url;
        this.tracks = new LinkedList<DashStreamDemuxerTrack>();
        this.coded = new LinkedList<SeekableDemuxerTrack>();
        try {
            this.mpd = MPDModel.parse(url);
            if (this.mpd != null && this.mpd.periods != null && this.mpd.periods.size() > 0) {
                MPDModel.Period period = this.mpd.periods.get(0);
                for (MPDModel.AdaptationSet adaptationSet : period.adaptationSets) {
                    DashStreamDemuxerTrack tr = new DashStreamDemuxerTrack(url, adaptationSet, period);
                    this.tracks.add(tr);
                    this.coded.add(new CodecMP4DemuxerTrack(tr));
                }
            }
        }
        catch (JCodecException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        for (DashStreamDemuxerTrack track : this.tracks) {
            track.close();
        }
    }

    @Override
    public List<? extends DemuxerTrack> getTracks() {
        return this.coded;
    }

    @Override
    public List<? extends DemuxerTrack> getVideoTracks() {
        ArrayList<SeekableDemuxerTrack> result = new ArrayList<SeekableDemuxerTrack>();
        for (SeekableDemuxerTrack demuxerTrack : this.coded) {
            DemuxerTrackMeta meta = demuxerTrack.getMeta();
            if (meta.getType() != TrackType.VIDEO) continue;
            result.add(demuxerTrack);
        }
        return result;
    }

    @Override
    public List<? extends DemuxerTrack> getAudioTracks() {
        ArrayList<SeekableDemuxerTrack> result = new ArrayList<SeekableDemuxerTrack>();
        for (SeekableDemuxerTrack demuxerTrack : this.coded) {
            DemuxerTrackMeta meta = demuxerTrack.getMeta();
            if (meta.getType() != TrackType.AUDIO) continue;
            result.add(demuxerTrack);
        }
        return result;
    }

    static class DashStreamDemuxerTrack
    implements SeekableDemuxerTrack,
    Closeable {
        private MPDModel.AdaptationSet adaptationSet;
        private URL url;
        private File initFile;
        private String selectedRprz;
        private Map<Integer, Future<DashMP4DemuxerTrack>> fragments = new HashMap<Integer, Future<DashMP4DemuxerTrack>>();
        private int curFragNo;
        private boolean streaming;
        private int maxDownloadAttampts = 1024;
        private ExecutorService threadPool;
        private int globalFrame;
        private MPDModel.Period period;
        private float frameRate;
        private double segmentDuration;
        private int[] seekFrames;
        static int next_id = 0;
        int id;

        public DashStreamDemuxerTrack(URL url, MPDModel.AdaptationSet adaptationSet, MPDModel.Period period) throws IOException {
            this.url = url;
            this.period = period;
            this.adaptationSet = adaptationSet;
            this.threadPool = Executors.newFixedThreadPool(INIT_SIZE, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    return t;
                }
            });
            if (adaptationSet.representations.size() > 0) {
                MPDModel.Representation rprz = adaptationSet.representations.get(0);
                this.selectedRprz = rprz.id;
                this.frameRate = rprz.frameRate == null ? 0.0f : rprz.frameRate.scalar();
                MPDModel.SegmentTemplate stpl = this.getSegmentTemplate();
                this.segmentDuration = stpl != null ? (double)stpl.duration / (double)stpl.timescale : period.duration.sec;
                this.downloadInit();
                for (int i = 0; i < INIT_SIZE; ++i) {
                    this.scheduleFragment(i);
                }
                int numSeg = (int)(period.duration.sec / this.segmentDuration);
                int segmentFrames = (int)(this.segmentDuration * (double)this.frameRate);
                this.seekFrames = new int[numSeg];
                int i = 0;
                int tmp = 0;
                while (i < numSeg) {
                    this.seekFrames[i] = tmp + 1;
                    ++i;
                    tmp += segmentFrames;
                }
            }
            this.id = next_id++;
        }

        private MPDModel.Representation getRrprz() {
            for (MPDModel.Representation rprz : this.adaptationSet.representations) {
                if (!rprz.id.equals(this.selectedRprz)) continue;
                return rprz;
            }
            return null;
        }

        private MPDModel.SegmentTemplate getSegmentTemplate() {
            MPDModel.Representation rprz = this.getRrprz();
            return this.adaptationSet.segmentTemplate == null ? rprz.segmentTemplate : this.adaptationSet.segmentTemplate;
        }

        private static void sleepQuiet(int millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private DashMP4DemuxerTrack downloadFrag(int no) throws IOException {
            MPDModel.Representation rprz = this.getRrprz();
            MPDModel.SegmentTemplate stpl = this.getSegmentTemplate();
            for (int i = 0; i < this.maxDownloadAttampts; ++i) {
                try {
                    URL urlInit = null;
                    if (stpl != null && stpl.media != null) {
                        HashMap<String, Object> vals = new HashMap<String, Object>();
                        vals.put("RepresentationID", this.selectedRprz);
                        vals.put("Number", stpl.startNumber + no);
                        String tmp = this.fillTemplate(stpl.media, vals);
                        urlInit = new URL(this.url, tmp);
                    } else if (rprz.segmentList != null && rprz.segmentList.segmentUrls.size() > no) {
                        MPDModel.SegmentURL segmentURL = rprz.segmentList.segmentUrls.get(no);
                        urlInit = new URL(this.url, segmentURL.media);
                    }
                    if (urlInit != null) {
                        File tempFile = File.createTempFile("net.creeperhost.blockshot.repack.org.jcodec", this.fileName(urlInit.getPath()));
                        System.out.println("Fetching fragment: " + urlInit.toExternalForm());
                        NIOUtils.fetchUrl(urlInit, tempFile);
                        DashMP4DemuxerTrack demuxer = DashMP4DemuxerTrack.createFromFiles(Arrays.asList(this.initFile, tempFile));
                        demuxer.setDurationHint(this.segmentDuration);
                        return demuxer;
                    }
                    if (rprz.baseURL != null) {
                        DashMP4DemuxerTrack demuxer = DashMP4DemuxerTrack.createFromFiles(Arrays.asList(this.initFile, this.initFile));
                        return demuxer;
                    }
                    break;
                }
                catch (FileNotFoundException e) {
                    if (!this.streaming) {
                        return null;
                    }
                    DashStreamDemuxerTrack.sleepQuiet(100);
                    continue;
                }
            }
            return null;
        }

        private String fillTemplate(String media, Map<String, Object> vals) {
            StringBuilder builder = new StringBuilder();
            char[] charArray = media.toCharArray();
            int varStart = 0;
            for (int i = 0; i < charArray.length; ++i) {
                if ('$' == charArray[i]) {
                    if (varStart == 0) {
                        varStart = i + 1;
                        continue;
                    }
                    String var = new String(charArray, varStart, i - varStart);
                    int formatStart = var.indexOf(37);
                    if (formatStart != -1) {
                        String format = var.substring(formatStart);
                        Object object = vals.get(var = var.substring(0, formatStart));
                        if (object != null) {
                            String val = String.format(format, object);
                            builder.append(val);
                        }
                    } else {
                        Object object = vals.get(var);
                        if (object != null) {
                            builder.append(String.valueOf(object));
                        }
                    }
                    varStart = 0;
                    continue;
                }
                if (varStart != 0) continue;
                builder.append(charArray[i]);
            }
            return builder.toString();
        }

        private String fileName(String path) {
            String[] split = path.split("/");
            return split[split.length - 1];
        }

        private void downloadInit() throws IOException {
            MPDModel.Representation rprz = this.getRrprz();
            if (this.getSegmentTemplate() != null && this.getSegmentTemplate().initialization != null) {
                String tmp = this.getSegmentTemplate().initialization.replace("$RepresentationID$", this.selectedRprz);
                URL urlInit = new URL(this.url, tmp);
                File tempFile = File.createTempFile("net.creeperhost.blockshot.repack.org.jcodec", this.fileName(urlInit.getPath()));
                System.out.println("Fetching init: " + urlInit.toExternalForm());
                NIOUtils.fetchUrl(urlInit, tempFile);
                this.initFile = tempFile;
            } else if (rprz.baseURL != null) {
                URL urlInit = new URL(this.url, rprz.baseURL);
                File tempFile = File.createTempFile("net.creeperhost.blockshot.repack.org.jcodec", this.fileName(urlInit.getPath()));
                System.out.println("Fetching init: " + urlInit.toExternalForm());
                NIOUtils.fetchUrl(urlInit, tempFile);
                this.initFile = tempFile;
            } else if (rprz.segmentList != null && rprz.segmentList.initialization != null) {
                URL urlInit = new URL(this.url, rprz.segmentList.initialization.sourceURL);
                File tempFile = File.createTempFile("net.creeperhost.blockshot.repack.org.jcodec", this.fileName(urlInit.getPath()));
                System.out.println("Fetching init: " + urlInit.toExternalForm());
                NIOUtils.fetchUrl(urlInit, tempFile);
                this.initFile = tempFile;
            }
        }

        @Override
        public Packet nextFrame() throws IOException {
            try {
                Future<DashMP4DemuxerTrack> curFrag = this.fragments.get(this.curFragNo);
                MP4Packet nextFrame = null;
                if (curFrag != null && (nextFrame = this.getCurFrag(curFrag).nextFrame()) == null) {
                    this.getCurFrag(curFrag).close();
                    this.fragments.put(this.curFragNo, null);
                    ++this.curFragNo;
                }
                if (nextFrame != null) {
                    ++this.globalFrame;
                    return this.setPts(nextFrame);
                }
                curFrag = this.fragments.get(this.curFragNo);
                if (curFrag == null) {
                    for (int i = this.curFragNo; i < this.curFragNo + INIT_SIZE; ++i) {
                        this.scheduleFragment(this.curFragNo);
                    }
                    curFrag = this.fragments.get(this.curFragNo);
                }
                if (curFrag == null) {
                    return null;
                }
                ++this.globalFrame;
                return this.setPts(this.getCurFrag(curFrag).nextFrame());
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Execution problem", e);
            }
        }

        private DashMP4DemuxerTrack getCurFrag(Future<DashMP4DemuxerTrack> curFrag) throws ExecutionException {
            while (true) {
                try {
                    return curFrag.get();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private MP4Packet setPts(MP4Packet frame) {
            double off = (double)this.curFragNo * this.segmentDuration;
            frame.setPts((long)((double)frame.getPts() + off * (double)frame.getTimescale()));
            frame.setMediaPts((long)((double)frame.getMediaPts() + off * (double)frame.getTimescale()));
            frame.setFrameNo(this.globalFrame - 1);
            if (this.id == 5) {
                System.out.println(String.format("[%d] PTS: %f DUR: %s", this.id, Float.valueOf((float)frame.getPtsD()), Float.valueOf((float)frame.getDurationD())));
            }
            return frame;
        }

        private void scheduleFragment(final int fragNo) {
            if (this.fragments.get(fragNo) == null) {
                Future<DashMP4DemuxerTrack> future = this.threadPool.submit(new Callable<DashMP4DemuxerTrack>(){

                    @Override
                    public DashMP4DemuxerTrack call() throws Exception {
                        return DashStreamDemuxerTrack.this.downloadFrag(fragNo);
                    }
                });
                this.fragments.put(fragNo, future);
            }
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            Future<DashMP4DemuxerTrack> future = this.fragments.get(this.curFragNo);
            if (future == null) {
                return null;
            }
            try {
                DashMP4DemuxerTrack frag = this.getCurFrag(future);
                MP4DemuxerTrackMeta fragMeta = (MP4DemuxerTrackMeta)frag.getMeta();
                double totalDuration = this.period.duration.sec;
                int totalFrames = (int)(this.period.duration.sec * (double)this.frameRate);
                return new MP4DemuxerTrackMeta(fragMeta.getType(), fragMeta.getCodec(), totalDuration, this.seekFrames, totalFrames, fragMeta.getCodecPrivate(), fragMeta.getVideoCodecMeta(), fragMeta.getAudioCodecMeta(), fragMeta.getSampleEntries(), fragMeta.getCodecPrivateOpaque());
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Execution problem", e);
            }
        }

        @Override
        public void close() throws IOException {
            Set<Map.Entry<Integer, Future<DashMP4DemuxerTrack>>> entrySet = this.fragments.entrySet();
            for (Map.Entry<Integer, Future<DashMP4DemuxerTrack>> entry : entrySet) {
                if (entry.getValue() == null) continue;
                try {
                    this.getCurFrag(entry.getValue()).close();
                }
                catch (ExecutionException e) {
                    throw new IOException("Execution problem", e);
                }
                entry.setValue(null);
            }
        }

        @Override
        public boolean gotoFrame(long frameNo) throws IOException {
            if (frameNo != 0L) {
                return false;
            }
            this.curFragNo = 0;
            this.globalFrame = 0;
            for (int i = 0; i < INIT_SIZE; ++i) {
                this.scheduleFragment(i);
            }
            return true;
        }

        @Override
        public boolean gotoSyncFrame(long frameNo) throws IOException {
            return false;
        }

        @Override
        public long getCurFrame() {
            return this.globalFrame;
        }

        @Override
        public void seek(double second) throws IOException {
            throw new RuntimeException("unimpl");
        }
    }
}

