/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer;

import java.nio.ByteBuffer;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.aac.AACUtils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.H264Utils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model.SeqParameterSet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.mp4.AvcCBox;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.Codec;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrackMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.Ints;
import net.creeperhost.blockshot.repack.org.jcodec.common.TrackType;
import net.creeperhost.blockshot.repack.org.jcodec.common.VideoCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.ColorSpace;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.RationalLarge;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.BoxUtil;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4TrackType;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.PixelAspectExt;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrackHeaderBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public class MP4DemuxerTrackMeta
extends DemuxerTrackMeta {
    private SampleEntry[] sampleEntries;
    private ByteBuffer codecPrivateOpaque;

    public MP4DemuxerTrackMeta(TrackType type, Codec codec, double totalDuration, int[] seekFrames, int totalFrames, ByteBuffer codecPrivate, VideoCodecMeta videoCodecMeta, AudioCodecMeta audioCodecMeta, SampleEntry[] sampleEntries, ByteBuffer codecMetaOpaque) {
        super(type, codec, totalDuration, seekFrames, totalFrames, codecPrivate, videoCodecMeta, audioCodecMeta);
        this.sampleEntries = sampleEntries;
        this.codecPrivateOpaque = codecMetaOpaque;
    }

    public SampleEntry[] getSampleEntries() {
        return this.sampleEntries;
    }

    public static DemuxerTrackMeta fromTrack(AbstractMP4DemuxerTrack track) {
        MP4TrackType type;
        int i;
        int[] seekFrames;
        int[] syncSamples;
        TrakBox trak = track.getBox();
        SyncSamplesBox stss = NodeBox.findFirstPath(trak, SyncSamplesBox.class, Box.path("mdia.minf.stbl.stss"));
        int[] nArray = syncSamples = stss == null ? null : stss.getSyncSamples();
        if (syncSamples == null) {
            seekFrames = new int[(int)track.getFrameCount()];
            for (i = 0; i < seekFrames.length; ++i) {
                seekFrames[i] = i;
            }
        } else {
            seekFrames = Platform.copyOfInt(syncSamples, syncSamples.length);
            i = 0;
            while (i < seekFrames.length) {
                int n = i++;
                seekFrames[n] = seekFrames[n] - 1;
            }
        }
        TrackType t = (type = track.getType()) == null ? TrackType.OTHER : type.getTrackType();
        VideoCodecMeta videoCodecMeta = MP4DemuxerTrackMeta.getVideoCodecMeta(track, trak, type);
        AudioCodecMeta audioCodecMeta = MP4DemuxerTrackMeta.getAudioCodecMeta(track, type);
        RationalLarge duration = track.getDuration();
        double sec = (double)duration.getNum() / (double)duration.getDen();
        int frameCount = Ints.checkedCast(track.getFrameCount());
        ByteBuffer opaque = MP4DemuxerTrackMeta.getCodecPrivateOpaque(Codec.codecByFourcc(track.getFourcc()), track.getSampleEntries()[0]);
        MP4DemuxerTrackMeta meta = new MP4DemuxerTrackMeta(t, Codec.codecByFourcc(track.getFourcc()), sec, seekFrames, frameCount, MP4DemuxerTrackMeta.getCodecPrivate(track), videoCodecMeta, audioCodecMeta, track.getSampleEntries(), opaque);
        meta.setIndex(track.getBox().getTrackHeader().getNo());
        if (type == MP4TrackType.VIDEO) {
            TrackHeaderBox tkhd = NodeBox.findFirstPath(trak, TrackHeaderBox.class, Box.path("tkhd"));
            DemuxerTrackMeta.Orientation orientation = tkhd.isOrientation90() ? DemuxerTrackMeta.Orientation.D_90 : (tkhd.isOrientation180() ? DemuxerTrackMeta.Orientation.D_180 : (tkhd.isOrientation270() ? DemuxerTrackMeta.Orientation.D_270 : DemuxerTrackMeta.Orientation.D_0));
            meta.setOrientation(orientation);
        }
        return meta;
    }

    public static ByteBuffer getCodecPrivateOpaque(Codec codec, SampleEntry se) {
        if (codec == Codec.H264) {
            Box b = NodeBox.findFirst(se, Box.class, "avcC");
            return b != null ? BoxUtil.writeBox(b) : null;
        }
        if (codec == Codec.AAC) {
            Box b = NodeBox.findFirst(se, Box.class, "esds");
            if (b == null) {
                b = NodeBox.findFirstPath(se, Box.class, new String[]{null, "esds"});
            }
            return b != null ? BoxUtil.writeBox(b) : null;
        }
        return null;
    }

    private static AudioCodecMeta getAudioCodecMeta(AbstractMP4DemuxerTrack track, MP4TrackType type) {
        AudioCodecMeta audioCodecMeta = null;
        if (type == MP4TrackType.SOUND) {
            AudioSampleEntry ase = (AudioSampleEntry)track.getSampleEntries()[0];
            audioCodecMeta = AudioCodecMeta.fromAudioFormat(ase.getFormat());
        }
        return audioCodecMeta;
    }

    private static VideoCodecMeta getVideoCodecMeta(AbstractMP4DemuxerTrack track, TrakBox trak, MP4TrackType type) {
        VideoCodecMeta videoCodecMeta = null;
        if (type == MP4TrackType.VIDEO) {
            videoCodecMeta = VideoCodecMeta.createSimpleVideoCodecMeta(trak.getCodedSize(), MP4DemuxerTrackMeta.getColorInfo(track));
            PixelAspectExt pasp = NodeBox.findFirst(track.getSampleEntries()[0], PixelAspectExt.class, "pasp");
            if (pasp != null) {
                videoCodecMeta.setPixelAspectRatio(pasp.getRational());
            }
        }
        return videoCodecMeta;
    }

    protected static ColorSpace getColorInfo(AbstractMP4DemuxerTrack track) {
        List<ByteBuffer> spsList;
        AvcCBox avcC;
        Codec codec = Codec.codecByFourcc(track.getFourcc());
        if (codec == Codec.H264 && (avcC = H264Utils.parseAVCC((VideoSampleEntry)track.getSampleEntries()[0])) != null && (spsList = avcC.getSpsList()).size() > 0) {
            SeqParameterSet sps = SeqParameterSet.read(spsList.get(0).duplicate());
            return sps.getChromaFormatIdc();
        }
        return null;
    }

    public static ByteBuffer getCodecPrivate(AbstractMP4DemuxerTrack track) {
        Codec codec = Codec.codecByFourcc(track.getFourcc());
        if (codec == Codec.H264) {
            AvcCBox avcC = H264Utils.parseAVCC((VideoSampleEntry)track.getSampleEntries()[0]);
            return avcC != null ? H264Utils.avcCToAnnexB(avcC) : null;
        }
        if (codec == Codec.AAC) {
            return AACUtils.getCodecPrivate(track.getSampleEntries()[0]);
        }
        return null;
    }

    public ByteBuffer getCodecPrivateOpaque() {
        return this.codecPrivateOpaque;
    }
}

