/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mxf.model;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import net.creeperhost.blockshot.repack.org.jcodec.common.logging.Logger;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mxf.model.MXFInterchangeObject;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mxf.model.UL;

public class GenericTrack
extends MXFInterchangeObject {
    private int trackId;
    private String name;
    private UL sequenceRef;
    private int trackNumber;

    public GenericTrack(UL ul) {
        super(ul);
    }

    @Override
    protected void read(Map<Integer, ByteBuffer> tags) {
        Iterator<Map.Entry<Integer, ByteBuffer>> it = tags.entrySet().iterator();
        block6: while (it.hasNext()) {
            Map.Entry<Integer, ByteBuffer> entry = it.next();
            ByteBuffer _bb = entry.getValue();
            switch (entry.getKey()) {
                case 18433: {
                    this.trackId = _bb.getInt();
                    break;
                }
                case 18434: {
                    this.name = this.readUtf16String(_bb);
                    break;
                }
                case 18435: {
                    this.sequenceRef = UL.read(_bb);
                    break;
                }
                case 18436: {
                    this.trackNumber = _bb.getInt();
                    break;
                }
                default: {
                    Logger.warn(String.format("Unknown tag [ " + this.ul + "]: %04x", entry.getKey()));
                    continue block6;
                }
            }
            it.remove();
        }
    }

    public int getTrackId() {
        return this.trackId;
    }

    public String getName() {
        return this.name;
    }

    public UL getSequenceRef() {
        return this.sequenceRef;
    }

    public int getTrackNumber() {
        return this.trackNumber;
    }
}

