/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mxf.model;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mxf.model.MXFPartitionPack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mxf.model.UL;

public class MXFPartition {
    private MXFPartitionPack pack;
    private long essenceFilePos;
    private boolean closed;
    private boolean complete;
    private long essenceLength;

    public MXFPartition(MXFPartitionPack pack, long essenceFilePos, boolean closed, boolean complete, long essenceLength) {
        this.pack = pack;
        this.essenceFilePos = essenceFilePos;
        this.closed = closed;
        this.complete = complete;
        this.essenceLength = essenceLength;
    }

    public static MXFPartition read(UL ul, ByteBuffer bb, long packSize, long nextPartition) {
        boolean closed = (ul.get(14) & 1) == 0;
        boolean complete = ul.get(14) > 2;
        MXFPartitionPack pp = new MXFPartitionPack(ul);
        pp.readBuf(bb);
        long essenceFilePos = MXFPartition.roundToKag(pp.getThisPartition() + packSize, pp.getKagSize()) + MXFPartition.roundToKag(pp.getHeaderByteCount(), pp.getKagSize()) + MXFPartition.roundToKag(pp.getIndexByteCount(), pp.getKagSize());
        return new MXFPartition(pp, essenceFilePos, closed, complete, nextPartition - essenceFilePos);
    }

    static long roundToKag(long position, int kag_size) {
        long ret = position / (long)kag_size * (long)kag_size;
        return ret == position ? ret : ret + (long)kag_size;
    }

    public MXFPartitionPack getPack() {
        return this.pack;
    }

    public long getEssenceFilePos() {
        return this.essenceFilePos;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public long getEssenceLength() {
        return this.essenceLength;
    }
}

