/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.FileChannelWrapper;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.tools.MainUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.BoxFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Util;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsetsBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleSizesBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleToChunkBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;

public class Concat {
    private static MainUtils.Flag[] flags = new MainUtils.Flag[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        MainUtils.Cmd cmd = MainUtils.parseArguments(args, flags);
        if (cmd.argsLength() < 2) {
            MainUtils.printHelpArgs(flags, new String[]{"output", "input*"});
            return;
        }
        FileChannelWrapper out = null;
        try {
            out = NIOUtils.writableChannel(new File(cmd.getArg(0)));
            MovieBox[] mv = new MovieBox[args.length - 1];
            long[] offsets = new long[args.length - 1];
            long prevOff = 0L;
            long mdatPos = 0L;
            long mdatSize = 0L;
            for (int i = 1; i < cmd.argsLength(); ++i) {
                File file = new File(cmd.getArg(i));
                offsets[i - 1] = prevOff;
                FileChannelWrapper in = null;
                try {
                    in = NIOUtils.readableChannel(file);
                    for (MP4Util.Atom atom : MP4Util.getRootAtoms(in)) {
                        if ("ftyp".equals(atom.getHeader().getFourcc()) && i == 1) {
                            atom.copy(in, out);
                            int n = i - 1;
                            offsets[n] = offsets[n] + atom.getHeader().getSize();
                            continue;
                        }
                        if ("mdat".equals(atom.getHeader().getFourcc())) {
                            if (i == 1) {
                                mdatPos = MP4Util.mdatPlaceholder(out);
                                int n = i - 1;
                                offsets[n] = offsets[n] + 16L;
                            }
                            atom.copyContents(in, out);
                            mdatSize += atom.getHeader().getBodySize();
                            int n = i - 1;
                            offsets[n] = offsets[n] - (atom.getOffset() + atom.getHeader().headerSize());
                            continue;
                        }
                        if (!"moov".equals(atom.getHeader().getFourcc())) continue;
                        mv[i - 1] = (MovieBox)atom.parseBox(in);
                    }
                    prevOff = out.position();
                    continue;
                }
                finally {
                    NIOUtils.closeQuietly(in);
                }
            }
            MovieBox movieBox = new Concat().concat(mv, offsets);
            MP4Util.writeMovie(out, movieBox);
            MP4Util.writeMdat(out, mdatPos, mdatSize);
        }
        catch (Throwable throwable) {
            NIOUtils.closeQuietly(out);
            throw throwable;
        }
        NIOUtils.closeQuietly(out);
    }

    public MovieBox concat(MovieBox[] movies, long[] offsets) throws IOException {
        int i;
        MovieBox result = (MovieBox)NodeBox.cloneBox(movies[0], 0x1000000, BoxFactory.getDefault());
        int prevTracks = 0;
        long totalDuration = 0L;
        for (i = 0; i < movies.length; ++i) {
            TrakBox[] tracks = movies[i].getTracks();
            if (i != 0 && prevTracks != tracks.length) {
                throw new RuntimeException("Incompatible movies. Movie " + i + " has different number of tracks (" + tracks.length + " vs " + prevTracks + ").");
            }
            prevTracks = tracks.length;
            totalDuration += movies[i].getDuration();
        }
        for (i = 0; i < prevTracks; ++i) {
            this.offsetTrack(result, movies, offsets, i);
        }
        result.setDuration(totalDuration);
        return result;
    }

    private void offsetTrack(MovieBox result, MovieBox[] movies, long[] offsets, int index) {
        TrakBox[] rtracks = result.getTracks();
        NodeBox rstbl = NodeBox.findFirstPath(rtracks[index], NodeBox.class, Box.path("mdia.minf.stbl"));
        int totalChunks = 0;
        int totalTts = 0;
        int totalSizes = 0;
        int defaultSize = 0;
        int totalCount = 0;
        int totalStsc = 0;
        long totalDuration = 0L;
        for (int i = 0; i < movies.length; ++i) {
            TrakBox trakBox = movies[i].getTracks()[index];
            ChunkOffsetsBox stco = trakBox.getStco();
            ChunkOffsets64Box co64 = trakBox.getCo64();
            TimeToSampleBox.TimeToSampleEntry[] entries = trakBox.getStts().getEntries();
            SampleSizesBox stsz = trakBox.getStsz();
            totalStsc += trakBox.getStsc().getSampleToChunk().length;
            if (stsz.getDefaultSize() != 0) {
                defaultSize = stsz.getDefaultSize();
                totalCount += stsz.getCount();
            } else {
                int[] sizes2 = stsz.getSizes();
                totalSizes += sizes2.length;
            }
            totalTts += entries.length;
            long[] chunkOffsets = stco != null ? stco.getChunkOffsets() : co64.getChunkOffsets();
            totalChunks += chunkOffsets.length;
            totalDuration += trakBox.getDuration();
        }
        long[] rOffsets = new long[totalChunks];
        int[] rSizes = null;
        if (defaultSize == 0) {
            rSizes = new int[totalSizes];
        }
        TimeToSampleBox.TimeToSampleEntry[] rTts = new TimeToSampleBox.TimeToSampleEntry[totalTts];
        SampleToChunkBox.SampleToChunkEntry[] rStsc = new SampleToChunkBox.SampleToChunkEntry[totalStsc];
        int lastChunks = 0;
        int rc = 0;
        int rt = 0;
        int rs = 0;
        int rsc = 0;
        for (int i = 0; i < movies.length; ++i) {
            TrakBox trakBox = movies[i].getTracks()[index];
            ChunkOffsetsBox stco = trakBox.getStco();
            ChunkOffsets64Box co64 = trakBox.getCo64();
            long[] chunkOffsets = stco != null ? stco.getChunkOffsets() : co64.getChunkOffsets();
            int c = 0;
            while (c < chunkOffsets.length) {
                rOffsets[rc] = chunkOffsets[c] + offsets[i];
                ++c;
                ++rc;
            }
            TimeToSampleBox.TimeToSampleEntry[] entries = trakBox.getStts().getEntries();
            int t = 0;
            while (t < entries.length) {
                rTts[rt] = entries[t];
                ++t;
                ++rt;
            }
            if (defaultSize == 0) {
                int[] sizes3 = trakBox.getStsz().getSizes();
                int s = 0;
                while (s < sizes3.length) {
                    rSizes[rs] = sizes3[s];
                    ++s;
                    ++rs;
                }
            }
            SampleToChunkBox.SampleToChunkEntry[] stscE = trakBox.getStsc().getSampleToChunk();
            int sc = 0;
            while (sc < stscE.length) {
                rStsc[rsc] = stscE[sc];
                rStsc[rsc].setFirst(rStsc[rsc].getFirst() + (long)lastChunks);
                ++sc;
                ++rsc;
            }
            lastChunks += chunkOffsets.length;
        }
        rstbl.replace("stts", TimeToSampleBox.createTimeToSampleBox(rTts));
        rstbl.replace("stsz", defaultSize == 0 ? SampleSizesBox.createSampleSizesBox2(rSizes) : SampleSizesBox.createSampleSizesBox(defaultSize, totalCount));
        rstbl.replace("stsc", SampleToChunkBox.createSampleToChunkBox(rStsc));
        rstbl.removeChildren(new String[]{"stco", "co64"});
        rstbl.add(ChunkOffsets64Box.createChunkOffsets64Box(rOffsets));
        rtracks[index].setDuration(totalDuration);
    }
}

