/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.creeperhost.blockshot.repack.org.jcodec.common.JCodecUtil2;
import net.creeperhost.blockshot.repack.org.jcodec.common.StringUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.FileChannelWrapper;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.BoxFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Util;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Edit;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;
import net.creeperhost.blockshot.repack.org.jcodec.movtool.Flatten;
import net.creeperhost.blockshot.repack.org.jcodec.movtool.Strip;
import net.creeperhost.blockshot.repack.org.jcodec.movtool.Util;

public class Cut {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main1(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Syntax: cut [-command arg]...[-command arg] [-self] <movie file>\n\tCreates a reference movie out of the file and applies a set of changes specified by the commands to it.");
            System.exit(-1);
        }
        ArrayList<Slice> slices = new ArrayList<Slice>();
        ArrayList<String> sliceNames = new ArrayList<String>();
        boolean selfContained = false;
        int shift = 0;
        while (true) {
            if ("-cut".equals(args[shift])) {
                String[] pt = StringUtils.splitS(args[shift + 1], ":");
                slices.add(new Slice(Integer.parseInt(pt[0]), Integer.parseInt(pt[1])));
                if (pt.length > 2) {
                    sliceNames.add(pt[2]);
                } else {
                    sliceNames.add(null);
                }
                shift += 2;
                continue;
            }
            if (!"-self".equals(args[shift])) break;
            ++shift;
            selfContained = true;
        }
        File source = new File(args[shift]);
        FileChannelWrapper input = null;
        Channel out = null;
        ArrayList outs = new ArrayList();
        try {
            List<MP4Util.Movie> slicesMovs;
            input = NIOUtils.readableChannel(source);
            MP4Util.Movie movie = MP4Util.createRefFullMovie(input, "file://" + source.getCanonicalPath());
            if (!selfContained) {
                out = NIOUtils.writableChannel(new File(source.getParentFile(), JCodecUtil2.removeExtension(source.getName()) + ".ref.mov"));
                slicesMovs = new Cut().cut(movie, slices);
                MP4Util.writeFullMovie((SeekableByteChannel)out, movie);
            } else {
                out = NIOUtils.writableChannel(new File(source.getParentFile(), JCodecUtil2.removeExtension(source.getName()) + ".self.mov"));
                slicesMovs = new Cut().cut(movie, slices);
                new Strip().stripToChunks(movie.getMoov());
                new Flatten().flattenChannel(movie, (SeekableByteChannel)out);
            }
            Cut.saveSlices(slicesMovs, sliceNames, source.getParentFile());
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (out != null) {
                out.close();
            }
            for (SeekableByteChannel o : outs) {
                o.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSlices(List<MP4Util.Movie> slices, List<String> names, File parentFile) throws IOException {
        for (int i = 0; i < slices.size(); ++i) {
            if (names.get(i) == null) continue;
            FileChannelWrapper out = null;
            try {
                out = NIOUtils.writableChannel(new File(parentFile, names.get(i)));
                MP4Util.writeFullMovie(out, slices.get(i));
            }
            catch (Throwable throwable) {
                NIOUtils.closeQuietly(out);
                throw throwable;
            }
            NIOUtils.closeQuietly(out);
        }
    }

    public List<MP4Util.Movie> cut(MP4Util.Movie movie, List<Slice> commands) {
        TrakBox[] tracks;
        MovieBox moov = movie.getMoov();
        TrakBox videoTrack = moov.getVideoTrack();
        if (videoTrack != null && videoTrack.getTimescale() != moov.getTimescale()) {
            moov.fixTimescale(videoTrack.getTimescale());
        }
        for (TrakBox trakBox : tracks = moov.getTracks()) {
            Util.forceEditList(moov, trakBox);
            for (Slice cut : commands) {
                this.split(cut.inSec, moov, trakBox);
                this.split(cut.outSec, moov, trakBox);
            }
        }
        ArrayList<MP4Util.Movie> result = new ArrayList<MP4Util.Movie>();
        for (Slice cut : commands) {
            MovieBox clone = (MovieBox)NodeBox.cloneBox(moov, 0x1000000, BoxFactory.getDefault());
            for (TrakBox trakBox : clone.getTracks()) {
                this.selectInner(trakBox.getEdits(), cut, moov);
            }
            result.add(new MP4Util.Movie(movie.getFtyp(), clone));
        }
        long movDuration = 0L;
        for (TrakBox trakBox : moov.getTracks()) {
            this.selectOuter(trakBox.getEdits(), commands, moov);
            trakBox.setEdits(trakBox.getEdits());
            movDuration = Math.max(movDuration, trakBox.getDuration());
        }
        moov.setDuration(movDuration);
        return result;
    }

    private void selectOuter(List<Edit> edits, List<Slice> commands, MovieBox movie) {
        long[] inMv = new long[commands.size()];
        long[] outMv = new long[commands.size()];
        for (int i = 0; i < commands.size(); ++i) {
            inMv[i] = (long)(commands.get(i).inSec * (double)movie.getTimescale());
            outMv[i] = (long)(commands.get(i).outSec * (double)movie.getTimescale());
        }
        long editStartMv = 0L;
        ListIterator<Edit> lit = edits.listIterator();
        while (lit.hasNext()) {
            Edit edit = lit.next();
            for (int i = 0; i < inMv.length; ++i) {
                if (editStartMv + edit.getDuration() <= inMv[i] || editStartMv >= outMv[i]) continue;
                lit.remove();
            }
            editStartMv += edit.getDuration();
        }
    }

    private void selectInner(List<Edit> edits, Slice cut, MovieBox movie) {
        long inMv = (long)((double)movie.getTimescale() * cut.inSec);
        long outMv = (long)((double)movie.getTimescale() * cut.outSec);
        long editStart = 0L;
        ListIterator<Edit> lit = edits.listIterator();
        while (lit.hasNext()) {
            Edit edit = lit.next();
            if (editStart + edit.getDuration() <= inMv || editStart >= outMv) {
                lit.remove();
            }
            editStart += edit.getDuration();
        }
    }

    private void split(double sec, MovieBox movie, TrakBox trakBox) {
        Util.split(movie, trakBox, (long)(sec * (double)movie.getTimescale()));
    }

    public static class Slice {
        private final double inSec;
        private final double outSec;

        public Slice(double _in, double out) {
            this.inSec = _in;
            this.outSec = out;
        }
    }
}

