/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.movtool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.creeperhost.blockshot.repack.org.jcodec.common.IntArrayList;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.Chunk;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.ChunkReader;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Edit;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;

public abstract class FixTimestamp {
    public void fixTimestamp(TrakBox trakBox, SeekableByteChannel ch) throws IOException {
        ChunkReader chr = new ChunkReader(trakBox, ch);
        long prevPts = -1L;
        long oldPts = 0L;
        int oldDur = -1;
        long editStart = 0L;
        long totalDur = 0L;
        IntArrayList durations = IntArrayList.createIntArrayList();
        while (chr.hasNext()) {
            Chunk next = chr.next();
            ByteBuffer data = next.getData().duplicate();
            int[] sampleSizes = next.getSampleSizes();
            int[] sampleDurs = next.getSampleDurs();
            for (int i = 0; i < sampleSizes.length; ++i) {
                long pts;
                int sz = sampleSizes[i];
                oldDur = sampleDurs != null ? sampleDurs[i] : next.getSampleDur();
                ByteBuffer sampleData = NIOUtils.read(data, sz);
                totalDur = pts = (long)(this.getPts(sampleData, oldPts, trakBox) * (double)trakBox.getTimescale());
                System.out.println("old: " + oldPts + ", new: " + pts);
                oldPts += (long)oldDur;
                if (prevPts != -1L && pts >= prevPts) {
                    long dur = pts - prevPts;
                    durations.add((int)dur);
                    prevPts = pts;
                    continue;
                }
                if (prevPts != -1L) continue;
                prevPts = pts;
                editStart = pts;
            }
        }
        if (oldDur != -1) {
            durations.add(oldDur);
            totalDur += (long)oldDur;
        }
        trakBox.getStbl().replaceBox(this.createStts(durations));
        if (editStart != 0L) {
            ArrayList<Edit> edits = new ArrayList<Edit>();
            edits.add(new Edit(-editStart, totalDur - editStart, 1.0f));
            trakBox.setEdits(edits);
        }
    }

    private Box createStts(IntArrayList durations) {
        TimeToSampleBox.TimeToSampleEntry[] entries = new TimeToSampleBox.TimeToSampleEntry[durations.size()];
        for (int i = 0; i < durations.size(); ++i) {
            entries[i] = new TimeToSampleBox.TimeToSampleEntry(1, durations.get(i));
        }
        return TimeToSampleBox.createTimeToSampleBox(entries);
    }

    protected abstract double getPts(ByteBuffer var1, double var2, TrakBox var4) throws IOException;
}

