/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.FileChannelWrapper;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.Chunk;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.ChunkReader;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.ChunkWriter;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Util;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.AliasBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsetsBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.DataRefBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.UrlBox;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public class Flatten {
    public List<ProgressListener> listeners;
    private Map<TrakBox, SampleProcessor> sampleProcessors = new HashMap<TrakBox, SampleProcessor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main1(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Syntax: self <ref movie> <out movie>");
            System.exit(-1);
        }
        File outFile = new File(args[1]);
        Platform.deleteFile(outFile);
        Channel input = null;
        try {
            input = NIOUtils.readableChannel(new File(args[0]));
            MP4Util.Movie movie = MP4Util.parseFullMovieChannel((SeekableByteChannel)input);
            new Flatten().flatten(movie, outFile);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public Flatten() {
        this.listeners = new ArrayList<ProgressListener>();
    }

    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    public boolean setSampleProcessor(TrakBox trak, SampleProcessor processor) {
        this.sampleProcessors.put(trak, processor);
        return true;
    }

    public void flattenChannel(MP4Util.Movie movie, SeekableByteChannel out) throws IOException {
        MovieBox moov = movie.getMoov();
        if (!moov.isPureRefMovie()) {
            throw new IllegalArgumentException("movie should be reference");
        }
        out.setPosition(0L);
        MP4Util.writeFullMovie(out, movie);
        int extraSpace = this.calcSpaceReq(moov);
        ByteBuffer buf = ByteBuffer.allocate(extraSpace);
        out.write(buf);
        long mdatOff = out.position();
        File[] inputFiles = this.getInputs(moov);
        SeekableByteChannel[] inputs = new SeekableByteChannel[inputFiles.length];
        for (int i = 0; i < inputFiles.length; ++i) {
            inputs[i] = NIOUtils.readableChannel(inputFiles[i]);
        }
        this.flattenInt(out, moov, inputs);
        long mdatSize = out.position() - mdatOff;
        out.setPosition(0L);
        MP4Util.writeFullMovie(out, movie);
        long extra = mdatOff - out.position();
        if (extra < 0L) {
            throw new IOException("Not enough space to write the header");
        }
        this.writeHeader(Header.createHeader("free", extra), out);
        out.setPosition(mdatOff);
        this.writeHeader(Header.createHeader("mdat", mdatSize), out);
        for (int i = 0; i < inputFiles.length; ++i) {
            NIOUtils.closeQuietly(inputs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flattenOnTop(MP4Util.Movie movie, File outF) throws IOException {
        MovieBox moov = movie.getMoov();
        if (!moov.isPureRefMovie()) {
            throw new IllegalArgumentException("movie should be reference");
        }
        FileChannelWrapper out = null;
        try {
            out = NIOUtils.rwChannel(outF);
            out.setPosition(0L);
            MP4Util.Atom atom = MP4Util.getMoov(MP4Util.getRootAtoms(out));
            long pos = atom.getOffset() + atom.getHeader().headerSize() - 4L;
            out.setPosition(pos);
            out.write(ByteBuffer.wrap(new byte[]{102, 114, 101, 101}));
            out.setPosition(out.size());
            long mdatOff = out.position();
            File[] inputFiles = this.getInputs(moov);
            SeekableByteChannel[] inputs = new SeekableByteChannel[inputFiles.length];
            for (int i = 0; i < inputFiles.length; ++i) {
                if (inputFiles[i].getCanonicalPath().contentEquals(outF.getCanonicalPath())) continue;
                inputs[i] = NIOUtils.readableChannel(inputFiles[i]);
            }
            this.flattenInt(out, moov, inputs);
            long mdatSize = out.position() - mdatOff;
            MP4Util.writeMovie(out, movie.getMoov());
            out.setPosition(mdatOff);
            this.writeHeader(Header.createHeader("mdat", mdatSize), out);
        }
        finally {
            NIOUtils.closeQuietly(out);
        }
    }

    private void flattenInt(SeekableByteChannel out, MovieBox moov, SeekableByteChannel[] inputs) throws IOException {
        int i;
        this.writeHeader(Header.createHeader("mdat", 0x100000001L), out);
        TrakBox[] tracks = moov.getTracks();
        ChunkReader[] readers = new ChunkReader[tracks.length];
        ChunkWriter[] writers = new ChunkWriter[tracks.length];
        Chunk[] head = new Chunk[tracks.length];
        int totalChunks = 0;
        int writtenChunks = 0;
        int lastProgress = 0;
        long[] off = new long[tracks.length];
        for (i = 0; i < tracks.length; ++i) {
            if (inputs[i] == null) continue;
            readers[i] = new ChunkReader(tracks[i], inputs[i]);
            totalChunks += readers[i].size();
            writers[i] = new ChunkWriter(tracks[i], inputs[i], out);
            head[i] = readers[i].next();
            if (!tracks[i].isVideo()) continue;
            off[i] = 2L * (long)moov.getTimescale();
        }
        while (true) {
            int min = -1;
            for (int i2 = 0; i2 < readers.length; ++i2) {
                long minTv;
                if (head[i2] == null) continue;
                if (min == -1) {
                    min = i2;
                    continue;
                }
                long iTv = moov.rescale(head[i2].getStartTv(), tracks[i2].getTimescale()) + off[i2];
                if (iTv >= (minTv = moov.rescale(head[min].getStartTv(), tracks[min].getTimescale()) + off[min])) continue;
                min = i2;
            }
            if (min == -1) break;
            SampleProcessor processor = this.sampleProcessors.get(tracks[min]);
            if (processor != null) {
                Chunk orig = head[min];
                orig.unpackSampleSizes();
                writers[min].write(Flatten.processChunk(processor, orig, tracks[min]));
                ++writtenChunks;
            } else {
                writers[min].write(head[min]);
                ++writtenChunks;
            }
            head[min] = readers[min].next();
            lastProgress = this.calcProgress(totalChunks, writtenChunks, lastProgress);
        }
        for (i = 0; i < tracks.length; ++i) {
            if (writers[i] == null) {
                ChunkWriter.cleanDrefs(tracks[i]);
                continue;
            }
            writers[i].apply();
        }
    }

    private static Chunk processChunk(SampleProcessor processor, Chunk orig, TrakBox track) throws IOException {
        ByteBuffer src = NIOUtils.duplicate(orig.getData());
        int[] sampleSizes = orig.getSampleSizes();
        int[] sampleDurs = orig.getSampleDurs();
        boolean uneqDur = orig.getSampleDur() == -1;
        LinkedList<ByteBuffer> modSamples = new LinkedList<ByteBuffer>();
        int totalSize = 0;
        int totalDur = 0;
        for (int ss = 0; ss < sampleSizes.length; ++ss) {
            ByteBuffer sample = NIOUtils.read(src, sampleSizes[ss]);
            int sampleDur = uneqDur ? sampleDurs[ss] : orig.getSampleDur();
            ByteBuffer modSample = processor.processSample(sample, (double)((long)totalDur + orig.getStartTv()) / (double)track.getTimescale(), (double)sampleDur / (double)track.getTimescale());
            totalDur += sampleDur;
            modSamples.add(modSample);
            totalSize += modSample.remaining();
        }
        byte[] result = new byte[totalSize];
        int[] modSizes = new int[modSamples.size()];
        int ss = 0;
        ByteBuffer tmp = ByteBuffer.wrap(result);
        for (ByteBuffer byteBuffer : modSamples) {
            modSizes[ss++] = byteBuffer.remaining();
            tmp.put(byteBuffer);
        }
        Chunk mod = Chunk.createFrom(orig);
        mod.setSampleSizes(modSizes);
        mod.setData(ByteBuffer.wrap(result));
        return mod;
    }

    private void writeHeader(Header header, SeekableByteChannel out) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(16);
        header.write(bb);
        ((Buffer)bb).flip();
        out.write(bb);
    }

    private int calcProgress(int totalChunks, int writtenChunks, int lastProgress) {
        int curProgress = 100 * writtenChunks / totalChunks;
        if (lastProgress < curProgress) {
            lastProgress = curProgress;
            for (ProgressListener pl : this.listeners) {
                pl.trigger(lastProgress);
            }
        }
        return lastProgress;
    }

    protected File[] getInputs(MovieBox movie) throws IOException {
        TrakBox[] tracks = movie.getTracks();
        File[] result = new File[tracks.length];
        for (int i = 0; i < tracks.length; ++i) {
            DataRefBox drefs = NodeBox.findFirstPath(tracks[i], DataRefBox.class, Box.path("mdia.minf.dinf.dref"));
            if (drefs == null) {
                throw new IOException("No data references");
            }
            List<Box> entries = drefs.getBoxes();
            if (entries.size() != 1) {
                throw new IOException("Concat tracks not supported");
            }
            result[i] = this.resolveDataRef(entries.get(0));
        }
        return result;
    }

    private int calcSpaceReq(MovieBox movie) {
        TrakBox[] tracks;
        int sum = 0;
        for (TrakBox trakBox : tracks = movie.getTracks()) {
            ChunkOffsetsBox stco = trakBox.getStco();
            if (stco == null) continue;
            sum += stco.getChunkOffsets().length * 4;
        }
        return sum;
    }

    public File resolveDataRef(Box box) throws IOException {
        if (box instanceof UrlBox) {
            String url = ((UrlBox)box).getUrl();
            if (!url.startsWith("file://")) {
                throw new RuntimeException("Only file:// urls are supported in data reference");
            }
            return new File(url.substring(7));
        }
        if (box instanceof AliasBox) {
            String uxPath = ((AliasBox)box).getUnixPath();
            if (uxPath == null) {
                throw new RuntimeException("Could not resolve alias");
            }
            return new File(uxPath);
        }
        throw new RuntimeException(box.getHeader().getFourcc() + " dataref type is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flatten(MP4Util.Movie movie, File video) throws IOException {
        Platform.deleteFile(video);
        FileChannelWrapper out = null;
        try {
            out = NIOUtils.writableChannel(video);
            this.flattenChannel(movie, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static interface ProgressListener {
        public void trigger(int var1);
    }

    public static interface SampleProcessor {
        public ByteBuffer processSample(ByteBuffer var1, double var2, double var4) throws IOException;
    }
}

