/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.common.ArrayUtil;
import net.creeperhost.blockshot.repack.org.jcodec.common.IntArrayList;
import net.creeperhost.blockshot.repack.org.jcodec.common.IntObjectMap;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.FileChannelWrapper;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.tools.MainUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.Brand;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Util;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.CompositionOffsetsBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MediaHeaderBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieFragmentBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleSizesBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleToChunkBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrackFragmentBaseMediaDecodeTimeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrackFragmentBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrackFragmentHeaderBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrunBox;

public class FragToMov {
    private static final MainUtils.Flag FLAG_INIT = MainUtils.Flag.flag("init", "i", "A file that contains global sequence headers");
    private static final MainUtils.Flag FLAG_OUT = MainUtils.Flag.flag("out", "o", "Output file");
    private static final MainUtils.Flag[] FLAGS = new MainUtils.Flag[]{FLAG_INIT, FLAG_OUT};
    private File init;
    private List<File> fragments = new LinkedList<File>();

    public static void main(String[] args) throws IOException {
        MainUtils.Cmd cmd = MainUtils.parseArguments(args, FLAGS);
        if (cmd.argsLength() < 1) {
            MainUtils.printHelpCmd("frag2mov", FLAGS, Arrays.asList("...out movie"));
            System.exit(-1);
            return;
        }
        FragToMov fragToMov = new FragToMov();
        if (cmd.getStringFlag(FLAG_INIT) != null) {
            fragToMov.setInit(new File(cmd.getStringFlag(FLAG_INIT)));
        }
        for (int i = 0; i < cmd.argsLength(); ++i) {
            fragToMov.addFragment(new File(cmd.getArg(i)));
        }
        fragToMov.toMovie(new File(cmd.getStringFlagD(FLAG_OUT, "out.mp4")));
    }

    private void addFragment(File file) {
        this.fragments.add(file);
    }

    private void setInit(File file) {
        this.init = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toMovie(File outFile) throws IOException {
        MovieBox initMov = null;
        if (this.init != null) {
            initMov = MP4Util.parseMovie(this.init);
        }
        LinkedList<Fragment> list = new LinkedList<Fragment>();
        FileChannelWrapper out = null;
        try {
            out = NIOUtils.writableChannel(outFile);
            out.write(MP4Util.writeBox(Brand.MP4.getFileTypeBox(), 32));
            long mdatPos = out.position();
            MP4Util.mdatPlaceholder(out);
            for (File file : this.fragments) {
                FileChannelWrapper in = null;
                try {
                    in = NIOUtils.readableChannel(file);
                    Fragment frag = FragToMov.createFragment();
                    for (MP4Util.Atom atom : MP4Util.getRootAtoms(in)) {
                        if ("moov".equals(atom.getHeader().getFourcc()) && initMov == null) {
                            initMov = (MovieBox)atom.parseBox(in);
                            continue;
                        }
                        if ("moof".equalsIgnoreCase(atom.getHeader().getFourcc())) {
                            frag.addBox((MovieFragmentBox)atom.parseBox(in), atom.getOffset());
                            continue;
                        }
                        if (!"mdat".equalsIgnoreCase(atom.getHeader().getFourcc())) continue;
                        frag.addOffset(out.position(), atom.getOffset() + atom.getHeader().headerSize(), atom.getHeader().getSize());
                        atom.copyContents(in, out);
                    }
                    list.add(frag);
                }
                finally {
                    NIOUtils.closeQuietly(in);
                }
            }
            long mdatSize = out.position() - mdatPos - 16L;
            MP4Util.writeMovie(out, FragToMov.getMoov(initMov, list));
            MP4Util.writeMdat(out, mdatPos, mdatSize);
        }
        finally {
            NIOUtils.closeQuietly(out);
        }
    }

    private static Fragment createFragment() {
        return new Fragment();
    }

    public static MovieBox getMoov(MovieBox init, List<Fragment> fragments) {
        if (init == null) {
            return null;
        }
        MovieBox movieBox = MovieBox.createMovieBox();
        IntObjectMap<ArrayList<TrackFragmentBox>> tracks = new IntObjectMap<ArrayList<TrackFragmentBox>>();
        for (Fragment frag : fragments) {
            for (BoxOffset bo : frag.boxes) {
                boolean no = false;
                for (TrackFragmentBox traf : bo.box.getTracks()) {
                    int trackId;
                    ArrayList<TrackFragmentBox> list;
                    long baseOff = traf.getTfhd().getBaseDataOffset() + bo.offset;
                    TrunBox trun = traf.getTrun();
                    for (Offset offset : frag.offsets) {
                        long dataOff = baseOff + trun.getDataOffset();
                        if (dataOff < offset.srcPos || dataOff >= offset.srcPos + offset.len) continue;
                        trun.setDataOffset(dataOff - offset.srcPos + offset.dstPos);
                        break;
                    }
                    if ((list = (ArrayList<TrackFragmentBox>)tracks.get(trackId = traf.getTfhd().getTrackId())) == null) {
                        list = new ArrayList<TrackFragmentBox>();
                        tracks.put(trackId, list);
                    }
                    list.add(traf);
                }
            }
        }
        movieBox.addFirst(init.getMovieHeader());
        int[] keys = tracks.keys();
        for (int i = 0; i < keys.length; ++i) {
            TrakBox trak = FragToMov.createTrack(movieBox, init.getTrackById(keys[i]), (List)tracks.get(keys[i]));
            movieBox.add(trak);
            if (trak.getDuration() <= movieBox.getDuration()) continue;
            movieBox.setDuration(trak.getDuration());
        }
        return movieBox;
    }

    private static TrakBox createTrack(MovieBox movie, TrakBox trakBox, List<TrackFragmentBox> list) {
        int defaultSampleSize = -1;
        int defaultSampleDuration = -1;
        LinkedList<int[]> sampleSizes = new LinkedList<int[]>();
        LinkedList<int[]> compOffsets = new LinkedList<int[]>();
        LinkedList<int[]> sampleDurations = new LinkedList<int[]>();
        IntArrayList sync = new IntArrayList(list.size());
        long[] co = new long[list.size()];
        SampleToChunkBox.SampleToChunkEntry[] sampleToCh = new SampleToChunkBox.SampleToChunkEntry[list.size()];
        int nSamples = 0;
        TimeToSampleBox.TimeToSampleEntry[] avgSampleDur = new TimeToSampleBox.TimeToSampleEntry[list.size()];
        int i = 0;
        long prevDecodeTime = 0L;
        for (TrackFragmentBox traf : list) {
            int ss;
            TrunBox trun = traf.getTrun();
            TrackFragmentBaseMediaDecodeTimeBox tfdt = traf.getTfdt();
            if (tfdt != null) {
                if (i > 0) {
                    avgSampleDur[i - 1] = new TimeToSampleBox.TimeToSampleEntry((int)trun.getSampleCount(), (int)((tfdt.getBaseMediaDecodeTime() - prevDecodeTime) / trun.getSampleCount()));
                }
                prevDecodeTime = tfdt.getBaseMediaDecodeTime();
            }
            co[i] = trun.getDataOffset();
            sampleToCh[i] = new SampleToChunkBox.SampleToChunkEntry(i + 1, (int)trun.getSampleCount(), 1);
            sync.add(nSamples + 1);
            nSamples = (int)((long)nSamples + trun.getSampleCount());
            ++i;
            TrackFragmentHeaderBox tfhd = traf.getTfhd();
            if (tfhd.isDefaultSampleSizeAvailable()) {
                ss = tfhd.getDefaultSampleSize();
                if (defaultSampleSize == -1) {
                    defaultSampleSize = ss;
                } else if (ss != defaultSampleSize) {
                    throw new RuntimeException("Incompatible fragments, default sample sizes differ.");
                }
            } else {
                sampleSizes.add(trun.getSampleSizes());
            }
            if (tfhd.isDefaultSampleDurationAvailable()) {
                ss = tfhd.getDefaultSampleDuration();
                if (defaultSampleDuration == -1) {
                    defaultSampleDuration = tfhd.getDefaultSampleDuration();
                } else if (ss != defaultSampleDuration) {
                    throw new RuntimeException("Incompatible fragments, default sample durations differ.");
                }
            } else if (trun.isSampleDurationAvailable()) {
                sampleDurations.add(trun.getSampleDurations());
            }
            if (!trun.isSampleCompositionOffsetAvailable()) continue;
            compOffsets.add(trun.getSampleCompositionOffsets());
        }
        if (avgSampleDur.length > 1) {
            avgSampleDur[avgSampleDur.length - 1] = avgSampleDur[avgSampleDur.length - 2];
        }
        SampleSizesBox stsz = defaultSampleSize != -1 ? SampleSizesBox.createSampleSizesBox(defaultSampleSize, nSamples) : SampleSizesBox.createSampleSizesBox2(ArrayUtil.flatten2DL(sampleSizes));
        TimeToSampleBox.TimeToSampleEntry[] tts = FragToMov.getStts(defaultSampleDuration, nSamples, sampleDurations);
        if (tts == null) {
            tts = avgSampleDur;
        }
        TimeToSampleBox stts = TimeToSampleBox.createTimeToSampleBox(tts);
        FragToMov.setTrackDuration(movie, trakBox, tts);
        ChunkOffsets64Box co64 = ChunkOffsets64Box.createChunkOffsets64Box(co);
        SampleToChunkBox stsc = SampleToChunkBox.createSampleToChunkBox(sampleToCh);
        trakBox.getStbl().replaceBox(stsz);
        trakBox.getStbl().replaceBox(stts);
        trakBox.getStbl().replaceBox(co64);
        trakBox.getStbl().replaceBox(stsc);
        trakBox.getStbl().replaceBox(CompositionOffsetsBox.createCompositionOffsetsBox(FragToMov.compactCompOffsets(compOffsets)));
        trakBox.getStbl().removeChildren(new String[]{"stco"});
        trakBox.getStbl().replaceBox(SyncSamplesBox.createSyncSamplesBox(sync.toArray()));
        return trakBox;
    }

    private static CompositionOffsetsBox.Entry[] compactCompOffsets(List<int[]> compOffsets) {
        LinkedList<CompositionOffsetsBox.Entry> res = new LinkedList<CompositionOffsetsBox.Entry>();
        int prev = 0;
        int count = 0;
        for (int[] is : compOffsets) {
            for (int i = 0; i < is.length; ++i) {
                if (count == 0 || is[i] == prev) {
                    ++count;
                    continue;
                }
                res.add(new CompositionOffsetsBox.Entry(count, prev));
                count = 1;
            }
        }
        if (count != 0) {
            res.add(new CompositionOffsetsBox.Entry(count, prev));
        }
        return res.toArray(new CompositionOffsetsBox.Entry[0]);
    }

    private static void setTrackDuration(MovieBox movie, TrakBox trakBox, TimeToSampleBox.TimeToSampleEntry[] tts) {
        long totalDur = 0L;
        for (TimeToSampleBox.TimeToSampleEntry tt : tts) {
            totalDur += tt.getSegmentDuration();
        }
        trakBox.setDuration(movie.rescale(totalDur, trakBox.getTimescale()));
        MediaHeaderBox mdhd = NodeBox.findFirstPath(trakBox, MediaHeaderBox.class, new String[]{"mdia", "mdhd"});
        mdhd.setDuration(totalDur);
    }

    private static TimeToSampleBox.TimeToSampleEntry[] getStts(int defaultSampleDuration, int nSamples, List<int[]> sampleDurations) {
        LinkedList<TimeToSampleBox.TimeToSampleEntry> tts = new LinkedList<TimeToSampleBox.TimeToSampleEntry>();
        if (defaultSampleDuration != -1) {
            tts.add(new TimeToSampleBox.TimeToSampleEntry(nSamples, defaultSampleDuration));
        } else if (sampleDurations.size() > 0) {
            for (int[] is : sampleDurations) {
                for (int i = 0; i < is.length; ++i) {
                    tts.add(new TimeToSampleBox.TimeToSampleEntry(1, is[i]));
                }
            }
        }
        return null;
    }

    private static class Fragment {
        List<BoxOffset> boxes = new LinkedList<BoxOffset>();
        List<Offset> offsets = new LinkedList<Offset>();

        public void addBox(MovieFragmentBox box, long offset) {
            this.boxes.add(new BoxOffset(box, offset));
        }

        public void addOffset(long dstPos, long srcPos, long len) {
            this.offsets.add(new Offset(dstPos, srcPos, len));
        }
    }

    private static class BoxOffset {
        MovieFragmentBox box;
        long offset;

        public BoxOffset(MovieFragmentBox box, long offset) {
            this.box = box;
            this.offset = offset;
        }
    }

    private static class Offset {
        long srcPos;
        long len;
        long dstPos;

        public Offset(long dstPos, long srcPos, long len) {
            this.dstPos = dstPos;
            this.srcPos = srcPos;
            this.len = len;
        }
    }
}

