/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.creeperhost.blockshot.repack.org.jcodec.common.Ints;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.FileChannelWrapper;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.IOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.BoxFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.BoxUtil;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Util;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;

public class MoovVersions {
    private static final byte[] MOOV_FOURCC = new byte[]{109, 111, 111, 118};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MP4Util.Atom> listMoovVersionAtoms(File file) throws IOException {
        ArrayList<MP4Util.Atom> result = new ArrayList<MP4Util.Atom>();
        FileChannelWrapper is = null;
        try {
            is = NIOUtils.readableChannel(file);
            for (MP4Util.Atom atom : MP4Util.getRootAtoms(is)) {
                if ("free".equals(atom.getHeader().getFourcc()) && MoovVersions.isMoov(is, atom)) {
                    result.add(atom);
                }
                if (!"moov".equals(atom.getHeader().getFourcc())) continue;
                result.add(atom);
                break;
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVersion(File file, MovieBox moov) throws IOException {
        long hdrsize = moov.getHeader().getSize();
        long estimate = moov.estimateSize();
        long size = Math.max(hdrsize, estimate) * 2L;
        ByteBuffer allocate = ByteBuffer.allocate(Ints.checkedCast(size));
        moov.write(allocate);
        allocate.flip();
        MP4Util.Atom oldmoov = MP4Util.findFirstAtomInFile("moov", file);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.seek(oldmoov.getOffset() + 4L);
            raf.write(Header.FOURCC_FREE);
            raf.seek(raf.length());
            raf.write(NIOUtils.toArray(allocate));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(raf);
            throw throwable;
        }
        IOUtils.closeQuietly(raf);
    }

    public static void undo(File file) throws IOException {
        List<MP4Util.Atom> versions = MoovVersions.listMoovVersionAtoms(file);
        if (versions.size() < 2) {
            throw new NoSuchElementException("Nowhere to rollback");
        }
        MoovVersions.rollback(file, versions.get(versions.size() - 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollback(File file, MP4Util.Atom version) throws IOException {
        MP4Util.Atom oldmoov = MP4Util.findFirstAtomInFile("moov", file);
        if (oldmoov.getOffset() == version.getOffset()) {
            throw new IllegalArgumentException("Already at version you are trying to rollback to");
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.seek(version.getOffset() + 4L);
            raf.write(MOOV_FOURCC);
            raf.seek(oldmoov.getOffset() + 4L);
            raf.write(Header.FOURCC_FREE);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(raf);
            throw throwable;
        }
        IOUtils.closeQuietly(raf);
    }

    private static boolean isMoov(SeekableByteChannel is, MP4Util.Atom atom) throws IOException {
        Header header = atom.getHeader();
        is.setPosition(atom.getOffset() + header.headerSize());
        try {
            Box mov = BoxUtil.parseBox(NIOUtils.fetchFromChannel(is, (int)header.getSize()), Header.createHeader("moov", header.getSize()), BoxFactory.getDefault());
            return mov instanceof MovieBox && BoxUtil.containsBox((NodeBox)mov, "mvhd");
        }
        catch (IOException t) {
            return false;
        }
    }
}

