/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.movtool;

import java.io.File;
import net.creeperhost.blockshot.repack.org.jcodec.common.logging.Logger;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.RationalLarge;
import net.creeperhost.blockshot.repack.org.jcodec.common.tools.MainUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieFragmentBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;
import net.creeperhost.blockshot.repack.org.jcodec.movtool.InplaceMP4Editor;
import net.creeperhost.blockshot.repack.org.jcodec.movtool.MP4Edit;

public class SetFPS {
    private static final int MIN_TIMESCALE_ALLOWED = 25;

    public static void main1(String[] args) throws Exception {
        MainUtils.Cmd cmd = MainUtils.parseArguments(args, new MainUtils.Flag[0]);
        if (cmd.argsLength() < 2) {
            MainUtils.printHelpNoFlags("movie", "num:den");
            System.exit(-1);
        }
        RationalLarge newFPS = RationalLarge.parse(cmd.getArg(1));
        new InplaceMP4Editor().modify(new File(cmd.getArg(0)), new SetFPSEdit(newFPS));
    }

    public static class SetFPSEdit
    implements MP4Edit {
        private final RationalLarge newFPS;

        public SetFPSEdit(RationalLarge newFPS) {
            this.newFPS = newFPS;
        }

        @Override
        public void apply(MovieBox mov) {
            TrakBox vt = mov.getVideoTrack();
            TimeToSampleBox stts = vt.getStts();
            TimeToSampleBox.TimeToSampleEntry[] entries = stts.getEntries();
            long nSamples = 0L;
            long totalDuration = 0L;
            for (TimeToSampleBox.TimeToSampleEntry e : entries) {
                nSamples += (long)e.getSampleCount();
                totalDuration += (long)(e.getSampleCount() * e.getSampleDuration());
            }
            int newTimescale = (int)this.newFPS.multiply(new RationalLarge(totalDuration, nSamples)).scalarClip();
            if (newTimescale >= 25) {
                vt.setTimescale(newTimescale);
                long newDuration = totalDuration * (long)mov.getTimescale() / (long)vt.getTimescale();
                mov.setDuration(newDuration);
                vt.setDuration(newDuration);
            } else {
                double mul = new RationalLarge((long)vt.getTimescale() * totalDuration, nSamples).divideBy(this.newFPS).scalar();
                Logger.info("Applying multiplier to sample durations: " + mul);
                for (TimeToSampleBox.TimeToSampleEntry e : entries) {
                    e.setSampleDuration((int)((double)e.getSampleDuration() * mul * 100.0));
                }
                vt.setTimescale(vt.getTimescale() * 100);
            }
            if (newTimescale != vt.getTimescale()) {
                Logger.info("Changing timescale to: " + vt.getTimescale());
                long newDuration = totalDuration * (long)mov.getTimescale() / (long)vt.getTimescale();
                mov.setDuration(newDuration);
                vt.setDuration(newDuration);
            }
        }

        @Override
        public void applyToFragment(MovieBox mov, MovieFragmentBox[] fragmentBox) {
            throw new RuntimeException("Unsupported");
        }
    }
}

