/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.charms;

import net.darkhax.bookshelf.api.util.MathsHelper;
import net.darkhax.bookshelf.mixin.accessors.effect.AccessorMobEffectInstance;
import net.darkhax.darkutilities.mixin.AccessorPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CharmEffects {
    public static void wardingCharmTick(ItemStack stack, Level world, Entity user, boolean selected) {
        LivingEntity living;
        if (user instanceof LivingEntity && !(living = (LivingEntity)user).getActiveEffects().isEmpty()) {
            CompoundTag effectTag = stack.hasTag() ? stack.getTagElement("effect") : null;
            float chance = effectTag != null && effectTag.contains("chance") ? effectTag.getFloat("chance") : 1.0f;
            for (MobEffectInstance effect : living.getActiveEffects()) {
                if (effect.isAmbient() || effect.getEffect().getCategory() != MobEffectCategory.HARMFUL || effect.getEffect().isInstantenous() || !MathsHelper.tryPercentage((double)chance) || !(effect instanceof AccessorMobEffectInstance)) continue;
                AccessorMobEffectInstance accessor = (AccessorMobEffectInstance)effect;
                accessor.bookshelf$tickDownDuration();
            }
        }
    }

    public static void sleepCharmTick(ItemStack stack, Level world, Entity user, boolean selected) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (player.isSleeping() && player instanceof AccessorPlayer) {
                AccessorPlayer accessor = (AccessorPlayer)player;
                if (player.getSleepTimer() < 90) {
                    accessor.darkutils$setSleepTimer(90);
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                splayer.getStats().setValue(player, Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), 0);
            }
        }
    }
}

