/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.tomes;

import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.darkutilities.features.tomes.ItemTome;
import net.darkhax.darkutilities.features.tomes.TomeEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;

public class ItemTomeFont
extends ItemTome {
    private final ResourceLocation fontId;
    private final Component fontPreview;

    public ItemTomeFont(ResourceLocation fontId) {
        super(null, ItemTomeFont.fontifyEntity(fontId), ItemTomeFont.fontifyBlock(fontId));
        this.fontId = fontId;
        this.fontPreview = TextHelper.applyFont((Component)Component.translatable((String)("font." + fontId.getNamespace() + "." + fontId.getPath() + ".preview")), (ResourceLocation)this.fontId);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, world, tooltip, flag);
        tooltip.add(this.fontPreview);
    }

    public static TomeEffect<BlockPos, InteractionResult> fontifyBlock(ResourceLocation fontId) {
        return (stack, player, hand, target) -> {
            BlockState block = player.level().getBlockState(target);
            BlockEntity blockEntity = player.level().getBlockEntity(target);
            if (blockEntity instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
                if (stack.hasCustomHoverName()) {
                    container.setCustomName(TextHelper.applyFont((Component)stack.getHoverName(), (ResourceLocation)fontId));
                    player.level().levelEvent(3002, target, -1);
                    return InteractionResult.SUCCESS;
                }
                container.setCustomName(TextHelper.applyFont((Component)container.getDisplayName(), (ResourceLocation)fontId));
                player.level().levelEvent(3002, target, -1);
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                sign.updateText(ItemTomeFont.applySignFont(fontId), true);
                sign.updateText(ItemTomeFont.applySignFont(fontId), false);
                sign.getLevel().sendBlockUpdated(sign.getBlockPos(), sign.getBlockState(), sign.getBlockState(), 3);
                player.level().levelEvent(3002, target, -1);
            }
            return null;
        };
    }

    private static UnaryOperator<SignText> applySignFont(ResourceLocation fontId) {
        return text -> {
            SignText newText = text;
            for (int i = 0; i < 4; ++i) {
                Component lineText = text.getMessage(i, false);
                if (lineText == CommonComponents.EMPTY || lineText.getContents() == PlainTextContents.EMPTY) continue;
                newText = newText.setMessage(i, TextHelper.applyFont((Component)lineText.copy(), (ResourceLocation)fontId));
            }
            return newText;
        };
    }

    public static TomeEffect<Entity, InteractionResult> fontifyEntity(ResourceLocation fontId) {
        return (stack, player, hand, target) -> {
            if (stack.hasCustomHoverName()) {
                target.setCustomName(TextHelper.applyFont((Component)stack.getHoverName(), (ResourceLocation)fontId));
                return InteractionResult.SUCCESS;
            }
            if (target.hasCustomName()) {
                target.setCustomName(TextHelper.applyFont((Component)target.getCustomName(), (ResourceLocation)fontId));
                return InteractionResult.SUCCESS;
            }
            return null;
        };
    }
}

