/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public interface SelectableResource<T> {
    public T stack();

    public long getCount();

    default public boolean isEmpty() {
        return this.getCount() == 0L;
    }

    public Component getName();

    public Icon getIcon();

    public SelectableResource<T> copyWithCount(long var1);

    public static SelectableResource<ItemStack> item(ItemStack stack) {
        return new ItemStackResource(stack);
    }

    public static SelectableResource<FluidStack> fluid(FluidStack stack) {
        return new FluidStackResource(stack);
    }

    public CompoundTag getTag();

    public void setTag(CompoundTag var1);

    public void setCount(int var1);

    public static final class ItemStackResource
    extends Record
    implements SelectableResource<ItemStack> {
        private final ItemStack stack;

        public ItemStackResource(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public long getCount() {
            return this.stack.getCount();
        }

        @Override
        public Component getName() {
            return this.stack.getHoverName();
        }

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(this.stack);
        }

        @Override
        public SelectableResource<ItemStack> copyWithCount(long count) {
            return SelectableResource.item(this.stack.copyWithCount((int)count));
        }

        @Override
        public CompoundTag getTag() {
            return this.stack.getTag();
        }

        @Override
        public void setTag(CompoundTag tag) {
            this.stack.setTag(tag);
        }

        @Override
        public void setCount(int count) {
            this.stack.setCount(count);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemStackResource.class, "stack", "stack"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemStackResource.class, "stack", "stack"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemStackResource.class, "stack", "stack"}, this, o);
        }

        @Override
        public ItemStack stack() {
            return this.stack;
        }
    }

    public static final class FluidStackResource
    extends Record
    implements SelectableResource<FluidStack> {
        private final FluidStack stack;

        public FluidStackResource(FluidStack stack) {
            this.stack = stack;
        }

        @Override
        public long getCount() {
            return this.stack().getAmount();
        }

        @Override
        public Component getName() {
            return this.stack.getName();
        }

        @Override
        public Icon getIcon() {
            return Icon.getIcon(ClientUtils.getStillTexture(this.stack)).withTint(Color4I.rgb(ClientUtils.getFluidColor(this.stack)));
        }

        @Override
        public SelectableResource<FluidStack> copyWithCount(long count) {
            return SelectableResource.fluid(this.stack.copyWithAmount(count));
        }

        @Override
        public CompoundTag getTag() {
            return this.stack.getTag();
        }

        @Override
        public void setTag(CompoundTag tag) {
            this.stack.setTag(tag);
        }

        @Override
        public void setCount(int count) {
            this.stack.setAmount((long)count);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FluidStackResource.class, "stack", "stack"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FluidStackResource.class, "stack", "stack"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FluidStackResource.class, "stack", "stack"}, this, o);
        }

        @Override
        public FluidStack stack() {
            return this.stack;
        }
    }

    public static class ImageResource
    implements SelectableResource<ResourceLocation> {
        private final ResourceLocation location;
        private final Component name;
        private final Icon icon;

        public ImageResource(ResourceLocation location) {
            this.location = location;
            this.name = location == null ? Component.translatable((String)"gui.none").withStyle(ChatFormatting.GRAY) : Component.literal((String)location.getNamespace()).withStyle(ChatFormatting.GOLD).append(":").append((Component)Component.literal((String)location.getPath()).withStyle(ChatFormatting.YELLOW));
            this.icon = Icon.getIcon(location);
        }

        @Override
        public ResourceLocation stack() {
            return this.location;
        }

        @Override
        public long getCount() {
            return 1L;
        }

        @Override
        public Component getName() {
            return this.name;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public SelectableResource<ResourceLocation> copyWithCount(long count) {
            return this;
        }

        @Override
        public CompoundTag getTag() {
            return null;
        }

        @Override
        public void setTag(CompoundTag tag) {
        }

        @Override
        public void setCount(int count) {
        }
    }
}

