/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.common.base.Objects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.IResourceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconProperties;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ImageIcon
extends Icon
implements IResourceIcon {
    public static final ResourceLocation MISSING_IMAGE = new ResourceLocation("ftblibrary", "textures/gui/missing_image.png");
    public final ResourceLocation texture;
    public float minU;
    public float minV;
    public float maxU;
    public float maxV;
    public double tileSize;
    public Color4I color;

    public ImageIcon(ResourceLocation tex) {
        this.texture = tex;
        this.minU = 0.0f;
        this.minV = 0.0f;
        this.maxU = 1.0f;
        this.maxV = 1.0f;
        this.tileSize = 0.0;
        this.color = Color4I.WHITE;
    }

    @Override
    public ImageIcon copy() {
        ImageIcon icon = new ImageIcon(this.texture);
        icon.minU = this.minU;
        icon.minV = this.minV;
        icon.maxU = this.maxU;
        icon.maxV = this.maxV;
        icon.tileSize = this.tileSize;
        return icon;
    }

    @Override
    protected void setProperties(IconProperties properties) {
        super.setProperties(properties);
        this.minU = (float)properties.getDouble("u0", this.minU);
        this.minV = (float)properties.getDouble("v0", this.minV);
        this.maxU = (float)properties.getDouble("u1", this.maxU);
        this.maxV = (float)properties.getDouble("v1", this.maxV);
        this.tileSize = properties.getDouble("tile_size", this.tileSize);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bindTexture() {
        TextureManager manager = Minecraft.getInstance().getTextureManager();
        AbstractTexture tex = manager.getTexture(this.texture);
        if (tex == null) {
            tex = new SimpleTexture(this.texture);
            manager.register(this.texture, tex);
        }
        RenderSystem.setShaderTexture((int)0, (int)tex.getId());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, int x, int y, int w, int h) {
        this.bindTexture();
        if (this.tileSize <= 0.0) {
            GuiHelper.drawTexturedRect(graphics, x, y, w, h, this.color, this.minU, this.minV, this.maxU, this.maxV);
        } else {
            int r = this.color.redi();
            int g = this.color.greeni();
            int b = this.color.bluei();
            int a = this.color.alphai();
            Matrix4f m = graphics.pose().last().pose();
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder buffer = tesselator.getBuilder();
            RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
            buffer.vertex(m, (float)x, (float)(y + h), 0.0f).color(r, g, b, a).uv((float)((double)x / this.tileSize), (float)((double)(y + h) / this.tileSize)).endVertex();
            buffer.vertex(m, (float)(x + w), (float)(y + h), 0.0f).color(r, g, b, a).uv((float)((double)(x + w) / this.tileSize), (float)((double)(y + h) / this.tileSize)).endVertex();
            buffer.vertex(m, (float)(x + w), (float)y, 0.0f).color(r, g, b, a).uv((float)((double)(x + w) / this.tileSize), (float)((double)y / this.tileSize)).endVertex();
            buffer.vertex(m, (float)x, (float)y, 0.0f).color(r, g, b, a).uv((float)((double)x / this.tileSize), (float)((double)y / this.tileSize)).endVertex();
            tesselator.end();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.texture, Float.valueOf(this.minU), Float.valueOf(this.minV), Float.valueOf(this.maxU), Float.valueOf(this.maxV)});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageIcon) {
            ImageIcon img = (ImageIcon)o;
            return this.texture.equals((Object)img.texture) && this.minU == img.minU && this.minV == img.minV && this.maxU == img.maxU && this.maxV == img.maxV;
        }
        return false;
    }

    public String toString() {
        return this.texture.toString();
    }

    @Override
    public ImageIcon withColor(Color4I color) {
        ImageIcon icon = this.copy();
        icon.color = color;
        return icon;
    }

    @Override
    public ImageIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }

    @Override
    public ImageIcon withUV(float u0, float v0, float u1, float v1) {
        ImageIcon icon = this.copy();
        icon.minU = u0;
        icon.minV = v0;
        icon.maxU = u1;
        icon.maxV = v1;
        return icon;
    }

    @Override
    public boolean hasPixelBuffer() {
        return true;
    }

    @Override
    @Nullable
    public PixelBuffer createPixelBuffer() {
        try {
            return PixelBuffer.from(((Resource)Minecraft.getInstance().getResourceManager().getResource(this.texture).orElseThrow()).open());
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.texture;
    }
}

