/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftblibrary.FTBLibraryCommands;
import dev.ftb.mods.ftblibrary.net.FTBLibraryNet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EditNBTResponsePacket
extends BaseC2SMessage {
    private final CompoundTag info;
    private final CompoundTag tag;

    public EditNBTResponsePacket(FriendlyByteBuf buf) {
        this.info = buf.readNbt();
        this.tag = buf.readNbt();
    }

    public EditNBTResponsePacket(CompoundTag i, CompoundTag t) {
        this.info = i;
        this.tag = t;
    }

    public MessageType getType() {
        return FTBLibraryNet.EDIT_NBT_RESPONSE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.info);
        buf.writeNbt((Tag)this.tag);
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        if (this.info.equals((Object)FTBLibraryCommands.EDITING_NBT.remove(player.getUUID()))) {
            switch (this.info.getString("type")) {
                case "block": {
                    BlockEntity blockEntity;
                    BlockPos pos = new BlockPos(this.info.getInt("x"), this.info.getInt("y"), this.info.getInt("z"));
                    if (!player.level().isLoaded(pos) || (blockEntity = player.level().getBlockEntity(pos)) == null) break;
                    this.tag.putInt("x", pos.getX());
                    this.tag.putInt("y", pos.getY());
                    this.tag.putInt("z", pos.getZ());
                    this.tag.putString("id", this.info.getString("id"));
                    blockEntity.load(this.tag);
                    blockEntity.setChanged();
                    player.level().sendBlockUpdated(pos, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                    break;
                }
                case "entity": {
                    Entity entity = player.level().getEntity(this.info.getInt("id"));
                    if (entity == null) break;
                    UUID uUID = entity.getUUID();
                    entity.load(this.tag);
                    entity.setUUID(uUID);
                    break;
                }
                case "player": {
                    ServerPlayer player1 = player.level().getServer().getPlayerList().getPlayer(this.info.getUUID("id"));
                    if (player1 == null) break;
                    UUID uUID = player1.getUUID();
                    player1.load(this.tag);
                    player1.setUUID(uUID);
                    player1.moveTo(player1.getX(), player1.getY(), player1.getZ());
                    break;
                }
                case "item": {
                    player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.of((CompoundTag)this.tag));
                }
            }
        }
    }
}

