/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.sidebar;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonGroup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public enum SidebarButtonManager implements ResourceManagerReloadListener
{
    INSTANCE;

    private final List<SidebarButtonGroup> groups = new ArrayList<SidebarButtonGroup>();

    public List<SidebarButtonGroup> getGroups() {
        return this.groups;
    }

    private JsonElement readJson(Resource resource) {
        JsonElement jsonElement;
        block8: {
            BufferedReader reader = resource.openAsReader();
            try {
                jsonElement = JsonParser.parseReader((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    FTBLibrary.LOGGER.warn("can't read {}: {}", (Object)resource.sourcePackId(), (Object)e.getMessage());
                    return JsonNull.INSTANCE;
                }
            }
            reader.close();
        }
        return jsonElement;
    }

    private JsonElement readJson(File file) {
        JsonElement jsonElement;
        FileReader reader = new FileReader(file);
        try {
            jsonElement = JsonParser.parseReader((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException | IOException e) {
                FTBLibrary.LOGGER.warn("can't read {}: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
                return JsonNull.INSTANCE;
            }
        }
        reader.close();
        return jsonElement;
    }

    public void onResourceManagerReload(ResourceManager manager) {
        JsonElement json;
        this.groups.clear();
        JsonElement element = this.readJson(Platform.getConfigFolder().resolve("sidebar_buttons.json").toFile());
        JsonObject sidebarButtonConfig = element.isJsonObject() ? element.getAsJsonObject() : new JsonObject();
        HashMap<ResourceLocation, SidebarButtonGroup> groupMap = new HashMap<ResourceLocation, SidebarButtonGroup>();
        for (String domain : manager.getNamespaces()) {
            try {
                for (Resource resource : manager.getResourceStack(new ResourceLocation(domain, "sidebar_button_groups.json"))) {
                    json = this.readJson(resource);
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                        JsonObject groupJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                        int y = 0;
                        boolean pinned = true;
                        if (groupJson.has("y")) {
                            y = groupJson.get("y").getAsInt();
                        }
                        if (groupJson.has("pinned")) {
                            pinned = groupJson.get("pinned").getAsBoolean();
                        }
                        SidebarButtonGroup group = new SidebarButtonGroup(new ResourceLocation(domain, (String)entry.getKey()), y, pinned);
                        groupMap.put(group.getId(), group);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (String domain : manager.getNamespaces()) {
            try {
                for (Resource resource : manager.getResourceStack(new ResourceLocation(domain, "sidebar_buttons.json"))) {
                    json = this.readJson(resource);
                    if (!json.isJsonObject()) continue;
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        SidebarButtonGroup group;
                        JsonObject buttonJson;
                        if (!((JsonElement)entry.getValue()).isJsonObject() || !(buttonJson = ((JsonElement)entry.getValue()).getAsJsonObject()).has("group") || buttonJson.has("dev_only") && buttonJson.get("dev_only").getAsBoolean() || (group = (SidebarButtonGroup)groupMap.get(new ResourceLocation(buttonJson.get("group").getAsString()))) == null) continue;
                        SidebarButton button = new SidebarButton(new ResourceLocation(domain, (String)entry.getKey()), group, buttonJson);
                        group.getButtons().add(button);
                        if (sidebarButtonConfig.has(button.getId().getNamespace())) {
                            JsonElement e = sidebarButtonConfig.get(button.getId().getNamespace());
                            if (!e.isJsonObject() || !e.getAsJsonObject().has(button.getId().getPath())) continue;
                            button.setConfig(e.getAsJsonObject().get(button.getId().getPath()).getAsBoolean());
                            continue;
                        }
                        if (!sidebarButtonConfig.has(button.getId().toString())) continue;
                        button.setConfig(sidebarButtonConfig.get(button.getId().toString()).getAsBoolean());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (SidebarButtonGroup group : groupMap.values()) {
            if (group.getButtons().isEmpty()) continue;
            group.getButtons().sort(null);
            this.groups.add(group);
        }
        this.groups.sort(null);
        for (SidebarButtonGroup group : this.groups) {
            for (SidebarButton button : group.getButtons()) {
                ((Consumer)SidebarButtonCreatedEvent.EVENT.invoker()).accept(new SidebarButtonCreatedEvent(button));
            }
        }
        this.saveConfig();
    }

    public void saveConfig() {
        JsonObject o = new JsonObject();
        for (SidebarButtonGroup group : this.groups) {
            for (SidebarButton button : group.getButtons()) {
                JsonObject o1 = o.getAsJsonObject(button.getId().getNamespace());
                if (o1 == null) {
                    o1 = new JsonObject();
                    o.add(button.getId().getNamespace(), (JsonElement)o1);
                }
                o1.addProperty(button.getId().getPath(), Boolean.valueOf(button.getConfig()));
            }
        }
        File file = Platform.getConfigFolder().resolve("sidebar_buttons.json").toFile();
        try (FileWriter writer = new FileWriter(file);){
            Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setIndent("\t");
            gson.toJson((JsonElement)o, jsonWriter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

