/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.sidebar;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonGroup;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGuiButton;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class SidebarGroupGuiButton
extends AbstractButton {
    public static Rect2i lastDrawnArea = new Rect2i(0, 0, 0, 0);
    private final List<SidebarGuiButton> buttons = new ArrayList<SidebarGuiButton>();
    private SidebarGuiButton mouseOver;

    public SidebarGroupGuiButton() {
        super(0, 0, 0, 0, (Component)Component.empty());
    }

    public void renderWidget(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.buttons.clear();
        this.mouseOver = null;
        int ry = 0;
        for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.getGroups()) {
            int rx = 0;
            boolean addedAny = false;
            for (SidebarButton sidebarButton : group.getButtons()) {
                if (!sidebarButton.isActuallyVisible()) continue;
                this.buttons.add(new SidebarGuiButton(rx, ry, sidebarButton));
                ++rx;
                addedAny = true;
            }
            if (!addedAny) continue;
            ++ry;
        }
        for (SidebarGuiButton button : this.buttons) {
            button.x = 1 + button.buttonX * 17;
            button.y = 1 + button.buttonY * 17;
        }
        this.setX(Integer.MAX_VALUE);
        this.setY(Integer.MAX_VALUE);
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (SidebarGuiButton sidebarGuiButton : this.buttons) {
            if (sidebarGuiButton.x >= 0 && sidebarGuiButton.y >= 0) {
                this.setX(Math.min(this.getX(), sidebarGuiButton.x));
                this.setY(Math.min(this.getY(), sidebarGuiButton.y));
                maxX = Math.max(maxX, sidebarGuiButton.x + 16);
                maxY = Math.max(maxY, sidebarGuiButton.y + 16);
            }
            if (mx < sidebarGuiButton.x || my < sidebarGuiButton.y || mx >= sidebarGuiButton.x + 16 || my >= sidebarGuiButton.y + 16) continue;
            this.mouseOver = sidebarGuiButton;
        }
        this.setX(Math.max(0, this.getX() - 2));
        this.setY(Math.max(0, this.getY() - 2));
        this.width = (maxX += 2) - this.getX();
        this.height = (maxY += 2) - this.getY();
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 500.0f);
        Font font = Minecraft.getInstance().font;
        for (SidebarGuiButton b : this.buttons) {
            String text;
            GuiHelper.setupDrawing();
            b.button.getIcon().draw(graphics, b.x, b.y, 16, 16);
            if (b == this.mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(graphics, b.x, b.y, 16, 16);
            }
            if (b.button.getCustomTextHandler() == null || (text = b.button.getCustomTextHandler().get()).isEmpty()) continue;
            int nw = font.width(text);
            int width = 16;
            Color4I.LIGHT_RED.draw(graphics, b.x + width - nw, b.y - 1, nw + 1, 9);
            graphics.drawString(font, text, b.x + width - nw + 1, b.y, -1);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.mouseOver != null) {
            GuiHelper.setupDrawing();
            int n = mx + 10;
            int my1 = Math.max(3, my - 9);
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.get((String)this.mouseOver.button.getLangKey(), (Object[])new Object[0]));
            if (this.mouseOver.button.getTooltipHandler() != null) {
                this.mouseOver.button.getTooltipHandler().accept(list);
            }
            int tw = 0;
            for (String s : list) {
                tw = Math.max(tw, font.width(s));
            }
            graphics.pose().translate(0.0f, 0.0f, 500.0f);
            Color4I.DARK_GRAY.draw(graphics, n - 3, my1 - 2, tw + 6, 2 + list.size() * 10);
            for (int i = 0; i < list.size(); ++i) {
                graphics.drawString(font, (String)list.get(i), n, my1 + i * 10, -1);
            }
        }
        GuiHelper.setupDrawing();
        lastDrawnArea = new Rect2i(this.getX(), this.getY(), this.width, this.height);
        graphics.pose().popPose();
    }

    public void onPress() {
        if (this.mouseOver != null) {
            this.mouseOver.button.onClicked(Screen.hasShiftDown());
        }
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

