/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class BaseContainer
extends AbstractContainerMenu {
    public BaseContainer(@Nullable MenuType<?> type, int id, Inventory playerInventory) {
        super(type, id);
    }

    public abstract int getNonPlayerSlots();

    public boolean stillValid(Player player) {
        return true;
    }

    public void addPlayerSlots(Inventory playerInventory, int posX, int posY, boolean ignoreCurrent) {
        int x;
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, posX + x * 18, posY + y * 18));
            }
        }
        int i = ignoreCurrent ? playerInventory.selected : -1;
        for (x = 0; x < 9; ++x) {
            if (x != i) {
                this.addSlot(new Slot((Container)playerInventory, x, posX + x * 18, posY + 58));
                continue;
            }
            this.addSlot(new Slot((Container)playerInventory, x, posX + x * 18, posY + 58){

                public boolean mayPickup(Player ep) {
                    return false;
                }
            });
        }
    }

    public void addPlayerSlots(Inventory playerInventory, int posX, int posY) {
        this.addPlayerSlots(playerInventory, posX, posY, false);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int nonPlayerSlots = this.getNonPlayerSlots();
        if (nonPlayerSlots <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack1 = slot.getItem();
            stack = stack1.copy();
            if (index < nonPlayerSlots ? !this.moveItemStackTo(stack1, nonPlayerSlots, this.slots.size(), true) : !this.moveItemStackTo(stack1, 0, nonPlayerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (stack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }
}

