/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.icon.PartIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class Theme {
    public static final Theme DEFAULT = new Theme();
    public static boolean renderDebugBoxes = false;
    public static final int DARK = 1;
    public static final int SHADOW = 2;
    public static final int CENTERED = 4;
    public static final int UNICODE = 8;
    public static final int MOUSE_OVER = 16;
    public static final int CENTERED_V = 32;
    private static final Color4I CONTENT_COLOR_MOUSE_OVER = Color4I.rgb(0xFFFFA0);
    private static final Color4I CONTENT_COLOR_DISABLED = Color4I.rgb(0xA0A0A0);
    private static final Color4I CONTENT_COLOR_DARK = Color4I.rgb(0x404040);
    public static final ImageIcon BACKGROUND_SQUARES = (ImageIcon)Icon.getIcon("ftblibrary:textures/gui/background_squares.png");
    private static final ImageIcon TEXTURE_BEACON = (ImageIcon)Icon.getIcon("textures/gui/container/beacon.png");
    private static final ImageIcon TEXTURE_RECIPE_BOOK = (ImageIcon)Icon.getIcon("textures/gui/recipe_book.png");
    private static final Icon GUI = new PartIcon("ftblibrary:textures/gui/background.png", 0, 0, 16, 16, 4, 16, 16);
    private static final Icon GUI_MOUSE_OVER = GUI.withTint(Color4I.rgb(11515610));
    private static final Icon BUTTON = PartIcon.wholeTexture("textures/gui/sprites/widget/button.png", 200, 20, 4);
    private static final Icon BUTTON_MOUSE_OVER = PartIcon.wholeTexture("textures/gui/sprites/widget/button_highlighted.png", 200, 20, 4);
    private static final Icon BUTTON_DISABLED = PartIcon.wholeTexture("textures/gui/sprites/widget/button_disabled.png", 200, 20, 4);
    private static final Icon WIDGET = PartIcon.wholeTexture("textures/gui/sprites/container/beacon/button.png", 22, 22, 4);
    private static final Icon WIDGET_MOUSE_OVER = PartIcon.wholeTexture("textures/gui/sprites/container/beacon/button_highlighted.png", 22, 22, 4);
    private static final Icon WIDGET_DISABLED = PartIcon.wholeTexture("textures/gui/sprites/container/beacon/button_disabled.png", 22, 22, 4);
    private static final Icon SCROLLER = PartIcon.wholeTexture("textures/gui/sprites/widget/slider_handle.png", 8, 20, 2);
    private static final Icon SCROLLER_MOUSE_OVER = PartIcon.wholeTexture("textures/gui/sprites/widget/slider_handle_highlighted.png", 8, 20, 2);
    private static final Icon SLOT = new PartIcon(TEXTURE_BEACON, 35, 136, 18, 18, 3);
    private static final Icon SLOT_MOUSE_OVER = SLOT.combineWith((Icon)Color4I.WHITE.withAlpha(33));
    private static final Icon SCROLL_BAR_BG = SLOT;
    private static final Icon SCROLL_BAR_BG_DISABLED = SCROLL_BAR_BG.withTint(Color4I.BLACK.withAlpha(100));
    private static final Icon TEXT_BOX = PartIcon.wholeTexture("textures/gui/sprites/container/enchanting_table/enchantment_slot_disabled.png", 108, 19, 4);
    private static final Icon TAB_H_UNSELECTED = TEXTURE_RECIPE_BOOK.withUV(150.0f, 2.0f, 35.0f, 26.0f, 256.0f, 256.0f);
    private static final Icon TAB_H_SELECTED = TEXTURE_RECIPE_BOOK.withUV(188.0f, 2.0f, 35.0f, 26.0f, 256.0f, 256.0f);
    private final BooleanStack fontUnicode = new BooleanArrayList();

    public Color4I getContentColor(WidgetType type) {
        return type == WidgetType.MOUSE_OVER ? CONTENT_COLOR_MOUSE_OVER : (type == WidgetType.DISABLED ? CONTENT_COLOR_DISABLED : Color4I.WHITE);
    }

    public Color4I getInvertedContentColor() {
        return CONTENT_COLOR_DARK;
    }

    public void drawGui(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? GUI_MOUSE_OVER : GUI).draw(graphics, x - 3, y - 3, w + 6, h + 6);
    }

    public void drawWidget(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? WIDGET_MOUSE_OVER : (type == WidgetType.DISABLED ? WIDGET_DISABLED : WIDGET)).draw(graphics, x, y, w, h);
    }

    public void drawSlot(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? SLOT_MOUSE_OVER : SLOT).draw(graphics, x, y, w, h);
    }

    public void drawContainerSlot(GuiGraphics graphics, int x, int y, int w, int h) {
        SLOT.draw(graphics, x - 1, y - 1, w + 2, h + 2);
    }

    public void drawButton(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? BUTTON_MOUSE_OVER : (type == WidgetType.DISABLED ? BUTTON_DISABLED : BUTTON)).draw(graphics, x, y, w, h);
    }

    public void drawScrollBarBackground(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.DISABLED ? SCROLL_BAR_BG_DISABLED : SCROLL_BAR_BG).draw(graphics, x, y, w, h);
    }

    public void drawScrollBar(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type, boolean vertical) {
        (type == WidgetType.MOUSE_OVER ? SCROLLER_MOUSE_OVER : SCROLLER).draw(graphics, x + 1, y + 1, w - 2, h - 2);
    }

    public void drawTextBox(GuiGraphics graphics, int x, int y, int w, int h) {
        TEXT_BOX.draw(graphics, x, y, w, h);
    }

    public void drawCheckboxBackground(GuiGraphics graphics, int x, int y, int w, int h, boolean radioButton) {
        this.drawSlot(graphics, x, y, w, h, WidgetType.NORMAL);
    }

    public void drawCheckbox(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type, boolean selected, boolean radioButton) {
        if (selected) {
            this.drawWidget(graphics, x, y, w, h, type);
        }
    }

    public void drawPanelBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        Color4I.rgb(0x8B8B8B).draw(graphics, x, y, w, h);
    }

    public void drawHorizontalTab(GuiGraphics graphics, int x, int y, int w, int h, boolean selected) {
        (selected ? TAB_H_SELECTED : TAB_H_UNSELECTED).draw(graphics, x, y, w, h);
    }

    public void drawContextMenuBackground(GuiGraphics graphics, int x, int y, int w, int h) {
        this.drawGui(graphics, x, y, w, h, WidgetType.NORMAL);
        Color4I.BLACK.withAlpha(90).draw(graphics, x, y, w, h);
    }

    public Font getFont() {
        return Minecraft.getInstance().font;
    }

    public final int getStringWidth(FormattedText text) {
        return text == Component.EMPTY ? 0 : this.getFont().width(text);
    }

    public final int getStringWidth(FormattedCharSequence text) {
        return text == FormattedCharSequence.EMPTY ? 0 : this.getFont().width(text);
    }

    public final int getStringWidth(String text) {
        return text.isEmpty() ? 0 : this.getFont().width(text);
    }

    public final int getFontHeight() {
        Objects.requireNonNull(this.getFont());
        return 9;
    }

    public final String trimStringToWidth(String text, int width) {
        return text.isEmpty() || width <= 0 ? "" : this.getFont().plainSubstrByWidth(text, width, false);
    }

    public final FormattedText trimStringToWidth(FormattedText text, int width) {
        return this.getFont().substrByWidth(text, width);
    }

    public final String trimStringToWidthReverse(String text, int width) {
        return text.isEmpty() || width <= 0 ? "" : this.getFont().plainSubstrByWidth(text, width, true);
    }

    public final List<FormattedText> listFormattedStringToWidth(FormattedText text, int width) {
        if (width <= 0 || text == Component.EMPTY) {
            return Collections.emptyList();
        }
        return this.getFont().getSplitter().splitLines(text, width, Style.EMPTY);
    }

    public final int drawString(GuiGraphics graphics, @Nullable Object text, int x, int y, Color4I color, int flags) {
        String s;
        if (text == null || text == FormattedCharSequence.EMPTY || text == Component.EMPTY || text instanceof String && (s = (String)text).isEmpty() || color.isEmpty()) {
            return x;
        }
        if (text instanceof FormattedCharSequence) {
            FormattedCharSequence fcs = (FormattedCharSequence)text;
            if (Bits.getFlag(flags, 4)) {
                x = (int)((float)x - (float)this.getStringWidth(fcs) / 2.0f);
            }
            int i = graphics.drawString(this.getFont(), (FormattedCharSequence)text, x, y, color.rgba(), Bits.getFlag(flags, 2));
            GuiHelper.setupDrawing();
            return i;
        }
        if (text instanceof Component) {
            Component comp = (Component)text;
            if (Bits.getFlag(flags, 4)) {
                x = (int)((float)x - (float)this.getStringWidth((FormattedText)comp) / 2.0f);
            }
            int i = graphics.drawString(this.getFont(), comp, x, y, color.rgba(), Bits.getFlag(flags, 2));
            GuiHelper.setupDrawing();
            return i;
        }
        if (text instanceof FormattedText) {
            return this.drawString(graphics, Language.getInstance().getVisualOrder((FormattedText)text), x, y, color, flags);
        }
        String s2 = String.valueOf(text);
        if (Bits.getFlag(flags, 4)) {
            x = (int)((float)x - (float)this.getStringWidth(s2) / 2.0f);
        }
        int i = graphics.drawString(this.getFont(), s2, x, y, color.rgba(), Bits.getFlag(flags, 2));
        GuiHelper.setupDrawing();
        return i;
    }

    public final int drawString(GuiGraphics graphics, @Nullable Object text, int x, int y, int flags) {
        return this.drawString(graphics, text, x, y, this.getContentColor(WidgetType.mouseOver(Bits.getFlag(flags, 16))), flags);
    }

    public final int drawString(GuiGraphics graphics, @Nullable Object text, int x, int y) {
        return this.drawString(graphics, text, x, y, this.getContentColor(WidgetType.NORMAL), 0);
    }
}

