/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.input;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.neoforge.KeyImpl;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class Key {
    public final int keyCode;
    public final int scanCode;
    public final KeyModifiers modifiers;

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean matchesWithoutConflicts(KeyMapping keyBinding, InputConstants.Key keyCode) {
        void var1_1;
        return KeyImpl.matchesWithoutConflicts(keyBinding, (InputConstants.Key)var1_1);
    }

    public Key(int k, int s, int m) {
        this.keyCode = k;
        this.scanCode = s;
        this.modifiers = new KeyModifiers(m);
    }

    public boolean is(int k) {
        return this.keyCode == k;
    }

    public InputConstants.Key getInputMapping() {
        return InputConstants.getKey((int)this.keyCode, (int)this.scanCode);
    }

    public boolean esc() {
        return this.is(256);
    }

    public boolean escOrInventory() {
        return this.esc() || Key.matchesWithoutConflicts(Minecraft.getInstance().options.keyInventory, this.getInputMapping());
    }

    public boolean enter() {
        return this.is(257);
    }

    public boolean backspace() {
        return this.is(259);
    }

    public boolean cut() {
        return Screen.isCut((int)this.keyCode);
    }

    public boolean paste() {
        return Screen.isPaste((int)this.keyCode);
    }

    public boolean copy() {
        return Screen.isCopy((int)this.keyCode);
    }

    public boolean selectAll() {
        return Screen.isSelectAll((int)this.keyCode);
    }

    public boolean deselectAll() {
        return this.keyCode == 68 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }
}

