/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.core.DisplayInfoFTBL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;

public class KnownServerRegistries {
    public static KnownServerRegistries client;
    public static KnownServerRegistries server;
    public final List<ResourceLocation> dimensions;
    public final Map<ResourceLocation, AdvancementInfo> advancements;

    public KnownServerRegistries(FriendlyByteBuf buffer) {
        int i;
        int s = buffer.readVarInt();
        this.dimensions = new ArrayList<ResourceLocation>(s);
        for (i = 0; i < s; ++i) {
            this.dimensions.add(buffer.readResourceLocation());
        }
        s = buffer.readVarInt();
        this.advancements = new LinkedHashMap<ResourceLocation, AdvancementInfo>(s);
        for (i = 0; i < s; ++i) {
            AdvancementInfo info = new AdvancementInfo();
            info.id = buffer.readResourceLocation();
            info.name = buffer.readComponent();
            info.icon = buffer.readItem();
            this.advancements.put(info.id, info);
        }
        FTBLibrary.LOGGER.debug("Received server registries");
    }

    public KnownServerRegistries(MinecraftServer server) {
        this.dimensions = new ArrayList<ResourceLocation>();
        for (ServerLevel level : server.getAllLevels()) {
            this.dimensions.add(level.dimension().location());
        }
        this.dimensions.sort(null);
        ArrayList<AdvancementInfo> advancementList = new ArrayList<AdvancementInfo>();
        for (AdvancementHolder advancement : server.getAdvancements().getAllAdvancements()) {
            Advancement value = advancement.value();
            Optional displayOpt = value.display();
            if (!displayOpt.isPresent() || !(value.display().get() instanceof DisplayInfoFTBL)) continue;
            DisplayInfo display = (DisplayInfo)displayOpt.get();
            AdvancementInfo info = new AdvancementInfo();
            info.id = advancement.id();
            info.name = display.getTitle();
            info.icon = ((DisplayInfoFTBL)display).getIconStackFTBL();
            advancementList.add(info);
        }
        advancementList.sort(Comparator.comparing(o -> o.id));
        this.advancements = new LinkedHashMap<ResourceLocation, AdvancementInfo>(advancementList.size());
        for (AdvancementInfo info : advancementList) {
            this.advancements.put(info.id, info);
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.dimensions.size());
        for (ResourceLocation id : this.dimensions) {
            buffer.writeResourceLocation(id);
        }
        buffer.writeVarInt(this.advancements.size());
        for (AdvancementInfo info : this.advancements.values()) {
            buffer.writeResourceLocation(info.id);
            buffer.writeComponent(info.name);
            buffer.writeItem(info.icon);
        }
    }

    public static class AdvancementInfo {
        public ResourceLocation id;
        public Component name;
        public ItemStack icon;
    }
}

