/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util.client;

import dev.architectury.event.EventActor;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.client.neoforge.ClientUtilsImpl;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ClientUtils {
    public static final BooleanSupplier IS_CLIENT_OP = () -> Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasPermissions(1);
    public static final List<Runnable> RUN_LATER = new ArrayList<Runnable>();
    private static final MethodType EMPTY_METHOD_TYPE = MethodType.methodType(Void.TYPE);
    private static final HashMap<String, Optional<MethodHandle>> staticMethodCache = new HashMap();

    public static void execClientCommand(String command, boolean printChat) {
        EventResult res;
        if (!command.isEmpty() && Minecraft.getInstance().player != null && !(res = ((ClientChatEvent.Send)ClientChatEvent.SEND.invoker()).send(command, null)).interruptsFurtherEvaluation()) {
            if (printChat) {
                Minecraft.getInstance().gui.getChat().addRecentChat(command);
            }
            Minecraft.getInstance().player.connection.sendCommand(command.replace("/", ""));
        }
    }

    public static void runLater(Runnable runnable) {
        RUN_LATER.add(runnable);
    }

    @Nullable
    public static <T> T getGuiAs(Screen gui, Class<T> clazz) {
        BaseScreen guiBase;
        if (gui instanceof IScreenWrapper && clazz.isAssignableFrom((guiBase = ((IScreenWrapper)gui).getGui()).getClass())) {
            return (T)guiBase;
        }
        return (T)(clazz.isAssignableFrom(gui.getClass()) ? Minecraft.getInstance().screen : null);
    }

    @Nullable
    public static <T> T getCurrentGuiAs(Class<T> clazz) {
        return Minecraft.getInstance().screen == null ? null : (T)ClientUtils.getGuiAs(Minecraft.getInstance().screen, clazz);
    }

    public static boolean handleClick(String scheme, String path) {
        switch (scheme) {
            case "http": 
            case "https": {
                try {
                    URI uri = new URI(scheme + ":" + path);
                    if (((Boolean)Minecraft.getInstance().options.chatLinksPrompt().get()).booleanValue()) {
                        Screen currentScreen = Minecraft.getInstance().screen;
                        Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(result -> {
                            if (result) {
                                try {
                                    Util.getPlatform().openUri(uri);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            Minecraft.getInstance().setScreen(currentScreen);
                        }, scheme + ":" + path, false));
                    } else {
                        Util.getPlatform().openUri(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "file": {
                try {
                    Util.getPlatform().openUri(new URI("file:" + path));
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "command": {
                ClientUtils.execClientCommand(path, false);
                return true;
            }
            case "static_method": {
                Optional<MethodHandle> handle = staticMethodCache.get(path);
                if (handle == null) {
                    handle = Optional.empty();
                    String[] s = path.split(":", 2);
                    try {
                        Class<?> c = Class.forName(s[0]);
                        MethodHandle h = MethodHandles.publicLookup().findStatic(c, s[1], EMPTY_METHOD_TYPE);
                        handle = Optional.ofNullable(h);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    staticMethodCache.put(path, handle);
                }
                if (handle.isPresent()) {
                    try {
                        handle.get().invoke();
                        return true;
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                return false;
            }
            case "custom": {
                if (!ResourceLocation.isValidResourceLocation((String)path)) break;
                return ((EventActor)CustomClickEvent.EVENT.invoker()).act((Object)new CustomClickEvent(new ResourceLocation(path))).isPresent();
            }
        }
        if (ResourceLocation.isValidResourceLocation((String)(scheme + ":" + path))) {
            return ((EventActor)CustomClickEvent.EVENT.invoker()).act((Object)new CustomClickEvent(new ResourceLocation(scheme, path))).isPresent();
        }
        FTBLibrary.LOGGER.warn("invalid scheme/path resourcelocation for handleClick(): {}:{}", (Object)scheme, (Object)path);
        return false;
    }

    public static HolderLookup.Provider registryAccess() {
        return Objects.requireNonNull(Minecraft.getInstance().level).registryAccess();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getStillTexture(FluidStack stack) {
        return ClientUtilsImpl.getStillTexture(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFluidColor(FluidStack stack) {
        return ClientUtilsImpl.getFluidColor(stack);
    }
}

