/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.util.StringRepresentable;

public class ImageComponent
implements ComponentContents {
    public static final MapCodec<ImageComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("image_id").forGetter(ImageComponent::imageStr), (App)Codec.INT.optionalFieldOf("width", (Object)100).forGetter(ImageComponent::getWidth), (App)Codec.INT.optionalFieldOf("height", (Object)100).forGetter(ImageComponent::getHeight), (App)ImageAlign.CODEC.optionalFieldOf("align", (Object)ImageAlign.CENTER).forGetter(ImageComponent::getAlign), (App)Codec.BOOL.optionalFieldOf("fit", (Object)false).forGetter(ImageComponent::isFit)).apply((Applicative)instance, ImageComponent::create));
    private static final ComponentContents.Type<ImageComponent> TYPE = new ComponentContents.Type(CODEC, "image");
    private Icon image = Icon.empty();
    private int width = 100;
    private int height = 100;
    private ImageAlign align = ImageAlign.CENTER;
    private boolean fit = false;

    public static ImageComponent create(String id, int width, int height, ImageAlign align, boolean fit) {
        ImageComponent c = new ImageComponent();
        c.image = Icon.getIcon(id);
        c.width = width;
        c.height = height;
        c.align = align;
        c.fit = fit;
        return c;
    }

    public String imageStr() {
        return this.image.toString();
    }

    public Icon getImage() {
        return this.image;
    }

    public void setImage(Icon image) {
        this.image = image;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setAlign(ImageAlign align) {
        this.align = align;
    }

    public void setFit(boolean fit) {
        this.fit = fit;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ImageAlign getAlign() {
        return this.align;
    }

    public boolean isFit() {
        return this.fit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{image:");
        sb.append(this.image);
        sb.append(" width:").append(this.width);
        sb.append(" height:").append(this.height);
        sb.append(" align:").append(this.align.getName());
        if (this.fit) {
            sb.append(" fit:true");
        }
        sb.append('}');
        return sb.toString();
    }

    public ComponentContents.Type<?> type() {
        return TYPE;
    }

    public static enum ImageAlign implements StringRepresentable
    {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right");

        public static final Codec<ImageAlign> CODEC;
        public static final NameMap<ImageAlign> NAME_MAP;
        private final String name;

        private ImageAlign(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ImageAlign byName(String name) {
            return NAME_MAP.get(name);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ImageAlign::values);
            NAME_MAP = NameMap.of(CENTER, ImageAlign.values()).id(v -> v.name).create();
        }
    }
}

