/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.toolstats;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.event.IEventHelper;
import net.darkhax.toolstats.Constants;
import net.darkhax.toolstats.config.ConfigSchema;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Blocks;

public class ToolStatsCommon {
    private final TagKey<Item> TAG_IGNORE = ToolStatsCommon.itemTag("ignored");
    private final TagKey<Item> TAG_IGNORE_HARVEST_LEVEL = ToolStatsCommon.itemTag("ignore_harvest_level");
    private final TagKey<Item> TAG_IGNORE_DIG_SPEED = ToolStatsCommon.itemTag("ignore_dig_speed");
    private final TagKey<Item> TAG_IGNORE_ENCHANTABILITY = ToolStatsCommon.itemTag("ignore_enchantability");
    private final TagKey<Item> TAG_IGNORE_REPAIR_COST = ToolStatsCommon.itemTag("ignore_repair_cost");
    private final TagKey<Item> TAG_IGNORE_DURABILITY = ToolStatsCommon.itemTag("ignore_durability");
    private final ConfigSchema config;
    private final Function<ItemStack, Integer> enchantabilityResolver;
    private final Function<Tier, Integer> harvestLevelResolver;
    private final Map<Integer, Component> enchantabilityCache = new ConcurrentHashMap<Integer, Component>();
    private final Map<Integer, Component> repairCostCache = new ConcurrentHashMap<Integer, Component>();
    private final Map<Integer, Component> harvestLevelCache = new ConcurrentHashMap<Integer, Component>();

    public ToolStatsCommon(Path configDir, Function<ItemStack, Integer> enchantabilityResolver, Function<Tier, Integer> harvestLevelResolver) {
        this.config = ConfigSchema.load(configDir.resolve("toolstats.json").toFile());
        this.enchantabilityResolver = enchantabilityResolver;
        this.harvestLevelResolver = harvestLevelResolver;
        Services.EVENTS.addItemTooltipListener(this::displayTooltipInfo, IEventHelper.Ordering.BEFORE);
    }

    private void displayTooltipInfo(ItemStack stack, List<Component> tooltip, TooltipFlag context) {
        if (!stack.is(this.TAG_IGNORE)) {
            int repairCost;
            int enchantability;
            float speed;
            ArrayList<Object> additions = new ArrayList<Object>();
            Item item = stack.getItem();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                if (!stack.is(this.TAG_IGNORE_HARVEST_LEVEL) && this.config.showHarvestLevel) {
                    additions.add(this.harvestLevelCache.computeIfAbsent(this.harvestLevelResolver.apply(tieredItem.getTier()), lvl -> Component.translatable((String)"tooltip.toolstats.harvestlevel", (Object[])new Object[]{lvl}).withStyle(ChatFormatting.DARK_GREEN)));
                }
            }
            if (!stack.is(this.TAG_IGNORE_DIG_SPEED) && this.config.showEfficiency && (!(stack.getItem() instanceof SwordItem) || this.config.showSwordEfficiency) && (speed = ToolStatsCommon.getDestroySpeed(stack)) > 0.0f) {
                additions.add(Component.translatable((String)"tooltip.toolstats.efficiency", (Object[])new Object[]{Constants.DECIMAL_FORMAT.format(speed)}).withStyle(ChatFormatting.DARK_GREEN));
            }
            if (!stack.is(this.TAG_IGNORE_ENCHANTABILITY) && this.config.showEnchantability && (this.config.alwaysShowEnchantability || Minecraft.getInstance().screen instanceof EnchantmentScreen) && (enchantability = this.enchantabilityResolver.apply(stack).intValue()) > 0) {
                additions.add(this.enchantabilityCache.computeIfAbsent(enchantability, enchLvl -> Component.translatable((String)"tooltip.toolstats.enchantability", (Object[])new Object[]{enchLvl}).withStyle(ChatFormatting.DARK_GREEN)));
            }
            if (!stack.is(this.TAG_IGNORE_REPAIR_COST) && this.config.showRepairCost && (this.config.alwaysShowRepairCost || Minecraft.getInstance().screen instanceof AnvilScreen) && (repairCost = stack.getBaseRepairCost()) > 0) {
                additions.add(this.repairCostCache.computeIfAbsent(repairCost, cost -> Component.translatable((String)"tooltip.toolstats.repaircost", (Object[])new Object[]{cost}).withStyle(ChatFormatting.DARK_GREEN)));
            }
            if (!context.isAdvanced() && !stack.is(this.TAG_IGNORE_DURABILITY) && this.config.showDurability && stack.isDamageableItem() && (this.config.alwaysShowDurability || stack.isDamaged())) {
                additions.add(Component.translatable((String)"item.durability", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue(), stack.getMaxDamage()}).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (this.config.showHorseArmorProtection && (item = stack.getItem()) instanceof HorseArmorItem) {
                HorseArmorItem horseArmor = (HorseArmorItem)item;
                additions.add(CommonComponents.EMPTY);
                additions.add(Component.translatable((String)"tooltip.toolstats.when_on.horse").withStyle(ChatFormatting.GRAY));
                additions.add(Component.translatable((String)("attribute.modifier.plus." + AttributeModifier.Operation.ADDITION.toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(horseArmor.getProtection()), Component.translatable((String)Attributes.ARMOR.getDescriptionId())}).withStyle(ChatFormatting.BLUE));
            }
            if (!additions.isEmpty()) {
                tooltip.addAll(ToolStatsCommon.getInsertOffset(context.isAdvanced(), tooltip.size(), stack), additions);
            }
        }
    }

    private static float getDestroySpeed(ItemStack stack) {
        int efficiencyLevel;
        float destroySpeed = ToolStatsCommon.getDestroySpeed(stack, stack.getItem());
        if (destroySpeed > 1.0f && (efficiencyLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.BLOCK_EFFICIENCY, (ItemStack)stack)) > 0) {
            destroySpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
        }
        return destroySpeed;
    }

    private static float getDestroySpeed(ItemStack stack, Item item) {
        if (item instanceof PickaxeItem) {
            PickaxeItem pickaxe = (PickaxeItem)item;
            return pickaxe.getDestroySpeed(stack, Blocks.COBBLESTONE.defaultBlockState());
        }
        if (item instanceof AxeItem) {
            AxeItem axe = (AxeItem)item;
            return axe.getDestroySpeed(stack, Blocks.OAK_PLANKS.defaultBlockState());
        }
        if (item instanceof ShovelItem) {
            ShovelItem shovel = (ShovelItem)item;
            return shovel.getDestroySpeed(stack, Blocks.DIRT.defaultBlockState());
        }
        if (item instanceof HoeItem) {
            HoeItem hoe = (HoeItem)item;
            return hoe.getDestroySpeed(stack, Blocks.DRIED_KELP_BLOCK.defaultBlockState());
        }
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            return sword.getDestroySpeed(stack, Blocks.SUNFLOWER.defaultBlockState());
        }
        if (item instanceof ShearsItem) {
            ShearsItem shears = (ShearsItem)item;
            return shears.getDestroySpeed(stack, Blocks.OAK_LEAVES.defaultBlockState());
        }
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            return tieredItem.getTier().getSpeed();
        }
        return 0.0f;
    }

    private static int getInsertOffset(boolean advanced, int tooltipSize, ItemStack stack) {
        int offset = 0;
        if (advanced) {
            ++offset;
            if (stack.hasTag()) {
                ++offset;
            }
            if (stack.isDamaged()) {
                ++offset;
            }
        }
        return Math.max(0, tooltipSize - offset);
    }

    private static TagKey<Item> itemTag(String key) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("toolstats", key));
    }
}

