/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.toolstats;

import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.darkhax.toolstats.ToolStatsCommon;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.TierSortingRegistry;
import net.neoforged.neoforge.common.extensions.IItemStackExtension;
import net.neoforged.neoforgespi.Environment;

@Mod(value="toolstats")
public class ToolStatsNeoForge {
    private final Map<Tier, Integer> tierCache = new WeakHashMap<Tier, Integer>();
    private final Map<Integer, Tier> vanillaTierLevels = Map.of(0, Tiers.WOOD, 1, Tiers.STONE, 2, Tiers.IRON, 3, Tiers.DIAMOND, 4, Tiers.NETHERITE);

    public ToolStatsNeoForge() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        if (Environment.get().getDist() == Dist.CLIENT) {
            ToolStatsCommon toolStatsCommon = new ToolStatsCommon(FMLPaths.CONFIGDIR.get(), IItemStackExtension::getEnchantmentValue, this::getTierLevel);
        }
    }

    public int getTierLevel(Tier tier) {
        if (!this.tierCache.containsKey(tier)) {
            if (TierSortingRegistry.isTierSorted((Tier)tier)) {
                this.tierCache.clear();
                int tierLevel = 0;
                for (Tier currentTier : TierSortingRegistry.getSortedTiers()) {
                    boolean isVanilla;
                    ResourceLocation id = TierSortingRegistry.getName((Tier)currentTier);
                    boolean bl = isVanilla = id != null && "minecraft".equals(id.getNamespace());
                    if (isVanilla || currentTier.getTag() != null && !ToolStatsNeoForge.isTagEmpty((TagKey<Block>)currentTier.getTag())) {
                        ++tierLevel;
                    }
                    this.tierCache.put(currentTier, tierLevel);
                }
            } else if (this.vanillaTierLevels.containsKey(tier.getLevel())) {
                this.tierCache.put(tier, this.getTierLevel(this.vanillaTierLevels.get(tier.getLevel())));
            }
        }
        return this.tierCache.computeIfAbsent(tier, t -> -1);
    }

    private static boolean isTagEmpty(TagKey<Block> key) {
        Optional holders = BuiltInRegistries.BLOCK.getTag(key);
        return holders == null || holders.isEmpty() || ((HolderSet.Named)holders.get()).size() <= 0;
    }
}

