/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels;

import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.event.IntegratedDynamicsSetupEvent;
import org.cyclops.integrateddynamics.core.part.aspect.AspectRegistry;
import org.cyclops.integrateddynamics.infobook.OnTheDynamicsOfIntegrationBook;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.RegistryEntries;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandlerRegistry;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandlerRegistry;
import org.cyclops.integratedtunnels.capability.ingredient.TunnelIngredientComponentCapabilities;
import org.cyclops.integratedtunnels.capability.network.TunnelNetworkCapabilityConstructors;
import org.cyclops.integratedtunnels.core.part.ContainerInterfaceSettingsConfig;
import org.cyclops.integratedtunnels.core.world.BlockBreakHandlerRegistry;
import org.cyclops.integratedtunnels.core.world.BlockBreakHandlers;
import org.cyclops.integratedtunnels.core.world.BlockBreakPlaceRegistry;
import org.cyclops.integratedtunnels.core.world.BlockPlaceHandlers;
import org.cyclops.integratedtunnels.item.ItemDummyPickAxeConfig;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;
import org.cyclops.integratedtunnels.part.aspect.listproxy.TunnelValueTypeListProxyFactories;
import org.cyclops.integratedtunnels.proxy.ClientProxy;
import org.cyclops.integratedtunnels.proxy.CommonProxy;

@Mod(value="integratedtunnels")
public class IntegratedTunnels
extends ModBaseVersionable<IntegratedTunnels> {
    public static IntegratedTunnels _instance;

    public IntegratedTunnels(IEventBus modEventBus) {
        super("integratedtunnels", instance -> {
            _instance = instance;
        }, modEventBus);
        this.getRegistryManager().addRegistry(IBlockBreakHandlerRegistry.class, (IRegistry)BlockBreakHandlerRegistry.getInstance());
        this.getRegistryManager().addRegistry(IBlockPlaceHandlerRegistry.class, (IRegistry)BlockBreakPlaceRegistry.getInstance());
        modEventBus.addListener(this::onRegistriesCreate);
        modEventBus.addListener(this::onSetup);
        modEventBus.addListener(Capabilities::registerPartCapabilities);
        modEventBus.register((Object)new TunnelNetworkCapabilityConstructors());
    }

    public void onRegistriesCreate(NewRegistryEvent event) {
        TunnelIngredientComponentCapabilities.load();
        TunnelAspects.load();
        PartTypes.load();
        BlockBreakHandlers.load();
        BlockPlaceHandlers.load();
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        TunnelValueTypeListProxyFactories.load();
    }

    protected void onSetup(IntegratedDynamicsSetupEvent event) {
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBase)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.manual", "/data/integratedtunnels/info/tunnels_info.xml");
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBase)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.tutorials", "/data/integratedtunnels/info/tunnels_tutorials.xml");
        AspectRegistry.getInstance().register((IPartType)org.cyclops.integrateddynamics.core.part.PartTypes.NETWORK_READER, (Collection)Lists.newArrayList((Object[])new IAspect[]{TunnelAspects.Read.Item.LONG_COUNT, TunnelAspects.Read.Item.LONG_COUNTMAX, TunnelAspects.Read.Item.LIST_ITEMSTACKS, TunnelAspects.Read.Item.OPERATOR_GETITEMCOUNT, TunnelAspects.Read.Item.INTEGER_INTERFACES, TunnelAspects.Read.Fluid.LONG_COUNT, TunnelAspects.Read.Fluid.LONG_COUNTMAX, TunnelAspects.Read.Fluid.LIST_FLUIDSTACKS, TunnelAspects.Read.Fluid.OPERATOR_GETFLUIDCOUNT, TunnelAspects.Read.Fluid.INTEGER_INTERFACES}));
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_PART_INTERFACE));
    }

    public void onConfigsRegister(ConfigHandler configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfig)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfig)new ItemDummyPickAxeConfig());
        configHandler.addConfigurable((ExtendedConfig)new ContainerInterfaceSettingsConfig());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    public static void clog(String message) {
        IntegratedTunnels.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

