/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.mixin.screen;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.FTBWorldsButton;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PauseScreen.class})
public class PauseScreenMixin {
    @Inject(method={"onDisconnect()V"}, at={@At(value="NEW", target="()Lnet/minecraft/client/gui/screens/TitleScreen;", ordinal=0)}, cancellable=true)
    private void onDisconnect(CallbackInfo ci) {
        if (RocketClientMod.getInstance().isConnectingToRocketServer() || RocketClientMod.getInstance().isOnRocketServer()) {
            ci.cancel();
            FTBWorldsButton.openMainScreen(RocketClientMod.getInstance().getClientHandler());
        }
    }

    @Inject(method={"createPauseMenu()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;isLocalServer()Z")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void createPauseMenu(CallbackInfo ci, GridLayout gridlayout, GridLayout.RowHelper rowHelper) {
        if (!RocketClientMod.getInstance().isLoaded()) {
            return;
        }
        UUID serverOwner = RocketClientMod.getInstance().getRocketServerOwner();
        if (serverOwner == null) {
            return;
        }
        if (RocketClientMod.getInstance().isOnRocketServer() && serverOwner.equals(Minecraft.getInstance().getUser().getProfileId())) {
            rowHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"rgp_client.gui.worlds_configuration.title"), button -> RocketClientMod.getInstance().openConfigurationScreen()).width(204).build(), 2);
        }
    }
}

