/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui;

import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketClientHandler;
import net.rocketplatform.game.client.mod.config.RocketClientModConfig;
import net.rocketplatform.game.client.mod.ui.MultilineErrorScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.util.RenderThreadUtils;
import org.jetbrains.annotations.Nullable;

public class FTBWorldsButton
extends Button {
    private FTBWorldsButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Button.CreateNarration createNarration) {
        super(x, y, width, height, message, onPress, createNarration);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public static FTBWorldsButton createVanilla(int defaultX, int defaultY, int width, int height) {
        if (!RocketClientMod.getInstance().isLoaded()) {
            return null;
        }
        Integer configX = (Integer)RocketClientModConfig.CONFIG.titleScreenButtonX.get();
        Integer configY = (Integer)RocketClientModConfig.CONFIG.titleScreenButtonY.get();
        CompletableFuture<RocketClientHandler> clientHandler = RocketClientMod.getInstance().getClientHandler();
        if (clientHandler.isCompletedExceptionally()) {
            clientHandler.exceptionally(t -> {
                RocketClientMod.getLogger().error("An error occurred when creating FTB Worlds button!", t);
                return null;
            });
            return FTBWorldsButton.errorButton(configX == -1 ? defaultX : configX, configY == -1 ? defaultY : configY, width, height, clientHandler);
        }
        return FTBWorldsButton.builder().message((Component)Component.translatable((String)"rgp_client.gui.button.ftb_worlds")).bounds(configX == -1 ? defaultX : configX, configY == -1 ? defaultY : configY, width, height).onPress(button -> FTBWorldsButton.buttonPressed()).build();
    }

    public static void buttonPressed() {
        CompletableFuture<RocketClientHandler> clientHandler = RocketClientMod.getInstance().getClientHandler();
        if (RocketClientMod.getInstance().hasFailedVersionCheck()) {
            clientHandler.whenCompleteAsync((client, e) -> {
                if (e != null) {
                    FTBWorldsButton.openErrorScreen(clientHandler);
                    return;
                }
                RocketClientMod.getInstance().processVersionSupport((RocketClientHandler)client).whenCompleteAsync((supported, ex) -> {
                    if (ex != null || !supported.booleanValue()) {
                        FTBWorldsButton.openErrorScreen(clientHandler);
                        return;
                    }
                    FTBWorldsButton.openMainScreen(clientHandler);
                }, RenderThreadUtils.RENDER_THREAD_EXECUTOR);
            }, RenderThreadUtils.RENDER_THREAD_EXECUTOR);
            return;
        }
        FTBWorldsButton.openMainScreen(clientHandler);
    }

    public static void openMainScreen(CompletableFuture<RocketClientHandler> clientHandler) {
        try {
            Runnable titleScreenRunnable = () -> {
                LayoutTemplate template = RocketClientMod.getInstance().getLayoutRepository().getLayout((String)RocketClientModConfig.CONFIG.titleScreenLayout.get());
                if (template == null) {
                    throw new IllegalStateException("Cannot find layout with id " + (String)RocketClientModConfig.CONFIG.titleScreenLayout.get());
                }
                Minecraft.getInstance().setScreen(template.createScreen(null));
            };
            if (clientHandler.isDone() && clientHandler.join().isConnected()) {
                titleScreenRunnable.run();
            } else {
                FTBWorldsButton.openErrorScreen(clientHandler);
            }
        }
        catch (Throwable t) {
            RocketClientMod.getLogger().error("An error occurred when creating FTB Worlds button!", t);
        }
    }

    private static FTBWorldsButton errorButton(int x, int y, int width, int height, CompletableFuture<RocketClientHandler> clientHandler) {
        return FTBWorldsButton.builder().message((Component)Component.translatable((String)"rgp_client.gui.button.ftb_worlds")).bounds(x, y, width, height).onPress(button -> FTBWorldsButton.openErrorScreen(clientHandler)).build();
    }

    private static FTBWorldsButton inBetaButton(int x, int y, int width, int height, String url) {
        return FTBWorldsButton.builder().message((Component)Component.translatable((String)"rgp_client.gui.button.ftb_worlds")).bounds(x, y, width, height).onPress(button -> {
            Screen currentScreen = Minecraft.getInstance().screen;
            Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(result -> {
                if (result) {
                    try {
                        Util.getPlatform().openUri(url);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Minecraft.getInstance().setScreen(currentScreen);
            }, (Component)Component.translatable((String)"rgp_client.early_access_no_access"), url, true));
        }).build();
    }

    private static void openErrorScreen(CompletableFuture<RocketClientHandler> clientHandler) {
        String reason;
        block7: {
            if (clientHandler.isCompletedExceptionally()) {
                try {
                    reason = "Please try again later.";
                    clientHandler.join();
                }
                catch (Throwable t) {
                    if (t.getCause() != null) {
                        reason = t.getCause().getMessage();
                        break block7;
                    }
                    reason = t.getMessage();
                }
            } else if (!clientHandler.isDone()) {
                reason = "A connection could not be established to the FTB Worlds service. Please ensure you are connected to the internet.";
            } else {
                reason = "Please try again later.";
                new Throwable().printStackTrace();
            }
        }
        MultilineErrorScreen errorScreen = new MultilineErrorScreen((Component)Component.translatable((String)"rgp_client.gui.button.ftb_worlds"), (Component)Component.translatable((String)"rgp_client.gui.service_unavailable", (Object[])new Object[]{reason}));
        Minecraft.getInstance().setScreen((Screen)errorScreen);
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return DEFAULT_NARRATION;
    }

    public static class Builder {
        private Component message;
        private Button.OnPress onPress;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Button.CreateNarration createNarration = FTBWorldsButton.access$000();

        public Builder message(Component message) {
            this.message = message;
            return this;
        }

        public Builder onPress(Button.OnPress onPress) {
            this.onPress = onPress;
            return this;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this;
        }

        public FTBWorldsButton build() {
            if (this.message == null) {
                throw new IllegalStateException("Cannot create button without message");
            }
            if (this.onPress == null) {
                throw new IllegalStateException("Cannot create button without onPress");
            }
            FTBWorldsButton button = new FTBWorldsButton(this.x, this.y, this.width, this.height, this.message, this.onPress, this.createNarration);
            button.setTooltip(this.tooltip);
            return button;
        }
    }
}

