/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui;

import dev.ftb.mods.ftblibrary.icon.Icon;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class MultilineToast
implements Toast {
    private static final ResourceLocation TEXTURE = new ResourceLocation("toast/advancement");
    private static final int MAX_LINE_SIZE = 200;
    private static final int LINE_SPACING = 12;
    private static final int MARGIN = 10;
    private static final int TOAST_WIDTH = 160;
    private static final int TOAST_HEIGHT = 32;
    private final long displayTime;
    private final Icon icon;
    private final Component title;
    private final List<FormattedCharSequence> messageLines;
    private long lastChanged;
    private boolean changed;
    private final int width;

    private MultilineToast(Icon icon, long displayTime, Component title, @Nullable Component message) {
        this(icon, displayTime, title, MultilineToast.nullToEmpty(message), Math.max(160, 30 + Math.max(Minecraft.getInstance().font.width((FormattedText)title), message == null ? 0 : Minecraft.getInstance().font.width((FormattedText)message))));
    }

    public static MultilineToast create(Minecraft minecraft, Icon icon, long displayTime, Component title, Component message) {
        List list = minecraft.font.split((FormattedText)message, 200);
        int lineWidth = Math.max(200, list.stream().mapToInt(arg_0 -> ((Font)minecraft.font).width(arg_0)).max().orElse(200));
        return new MultilineToast(icon, displayTime, title, list, lineWidth + 30);
    }

    private MultilineToast(Icon icon, long displayTime, Component title, List<FormattedCharSequence> messageLines, int width) {
        this.icon = icon;
        this.displayTime = displayTime;
        this.title = title;
        this.messageLines = messageLines;
        this.width = width;
    }

    private static List<FormattedCharSequence> nullToEmpty(@Nullable Component message) {
        return message == null ? List.of() : List.of(message.getVisualOrderText());
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        int height;
        int width;
        if (this.changed) {
            this.lastChanged = timeSinceLastVisible;
            this.changed = false;
        }
        if ((width = this.width()) == 160 && this.messageLines.size() <= 1) {
            guiGraphics.blitSprite(TEXTURE, 0, 0, width, this.height());
        } else {
            height = this.height();
            int lineHeight = Math.min(4, height - 28);
            this.renderBackgroundRow(guiGraphics, width, 0, 0, 28);
            for (int i = 28; i < height - lineHeight; i += 10) {
                this.renderBackgroundRow(guiGraphics, width, 16, i, Math.min(16, height - i - lineHeight));
            }
            this.renderBackgroundRow(guiGraphics, width, 32 - lineHeight, height - lineHeight, lineHeight);
        }
        if (this.messageLines == null) {
            guiGraphics.drawString(toastComponent.getMinecraft().font, this.title, 30, 12, -256, false);
        } else {
            guiGraphics.drawString(toastComponent.getMinecraft().font, this.title, 30, 7, -256, false);
            for (height = 0; height < this.messageLines.size(); ++height) {
                guiGraphics.drawString(toastComponent.getMinecraft().font, this.messageLines.get(height), 30, 18 + height * 12, -1, false);
            }
        }
        if (this.icon != null) {
            this.icon.draw(guiGraphics, 8, 8, 16, 16);
        }
        return (double)(timeSinceLastVisible - this.lastChanged) < (double)this.displayTime * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    private void renderBackgroundRow(GuiGraphics guiGraphics, int width, int vOffset, int y, int height) {
        int leftPadding = vOffset == 0 ? 20 : 5;
        int rightPadding = Math.min(60, width - leftPadding);
        guiGraphics.blitSprite(TEXTURE, 160, 32, 0, vOffset, 0, y, leftPadding, height);
        for (int x = leftPadding; x < width - rightPadding; x += 64) {
            guiGraphics.blitSprite(TEXTURE, 160, 32, 32, vOffset, x, y, Math.min(64, width - x - rightPadding), height);
        }
        guiGraphics.blitSprite(TEXTURE, 160, 32, 160 - rightPadding, vOffset, width - rightPadding, y, rightPadding, height);
    }
}

